/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiUtil {
    @NotNull
    public static JComponent installProgress(@NotNull JComponent component, final @NotNull VcsLogData logData, final @NotNull String logId, @NotNull Disposable disposableParent) {
        final ProgressStripe progressStripe = new ProgressStripe(component, disposableParent, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && logData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        logData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (this.matches(keys)) {
                    progressStripe.startLoading();
                }
            }

            @Override
            public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (this.matches(keys)) {
                    progressStripe.startLoading();
                } else {
                    progressStripe.stopLoading();
                }
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }

            private boolean matches(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
                if (keys.contains(VcsLogData.DATA_PACK_REFRESH)) {
                    return true;
                }
                return ContainerUtil.find(keys, key -> VisiblePackRefresherImpl.isVisibleKeyFor(key, logId)) != null;
            }
        }, disposableParent);
        return progressStripe;
    }

    @NotNull
    public static JScrollPane setupScrolledGraph(@NotNull VcsLogGraphTable graphTable, int border) {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable), (int)border);
        graphTable.viewportSet(scrollPane.getViewport());
        return scrollPane;
    }

    public static void installDetailsListeners(@NotNull VcsLogGraphTable graphTable, @NotNull DetailsPanel detailsPanel, @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        Runnable miniDetailsLoadedListener = () -> {
            graphTable.reLayout();
            graphTable.repaint();
        };
        Runnable containingBranchesListener = () -> {
            detailsPanel.branchesChanged();
            graphTable.repaint();
        };
        logData.getMiniDetailsGetter().addDetailsLoadedListener(miniDetailsLoadedListener);
        logData.getContainingBranchesGetter().addTaskCompletedListener(containingBranchesListener);
        Disposer.register((Disposable)disposableParent, () -> {
            logData.getContainingBranchesGetter().removeTaskCompletedListener(containingBranchesListener);
            logData.getMiniDetailsGetter().removeDetailsLoadedListener(miniDetailsLoadedListener);
        });
    }

    @NotNull
    public static SimpleTextAttributes getLinkAttributes() {
        return new SimpleTextAttributes(0, JBUI.CurrentTheme.Link.linkColor());
    }

    public static void showTooltip(@NotNull JComponent component, @NotNull Point point, @NotNull Balloon.Position position, @NotNull String text) {
        JEditorPane tipComponent = IdeTooltipManager.initPane(text, new HintHint(component, point).setAwtTooltip(true), null);
        IdeTooltip tooltip = new IdeTooltip(component, point, (JComponent)new Wrapper((JComponent)tipComponent), new Object[0]).setPreferredPosition(position).setToCenter(false).setToCenterIfSmall(false);
        IdeTooltipManager.getInstance().show(tooltip, false);
    }

    @NotNull
    public static History installNavigationHistory(@NotNull AbstractVcsLogUi ui) {
        History history = new History((Place.Navigator)new VcsLogPlaceNavigator(ui));
        ui.getTable().getSelectionModel().addListSelectionListener(e -> {
            if (!history.isNavigatingNow() && !e.getValueIsAdjusting()) {
                history.pushQueryPlace();
            }
        });
        return history;
    }

    private static class VcsLogPlaceNavigator
    implements Place.Navigator {
        private static final String PLACE_KEY = "Vcs.Log.Ui.History.PlaceKey";
        @NotNull
        private final AbstractVcsLogUi myUi;

        private VcsLogPlaceNavigator(@NotNull AbstractVcsLogUi ui) {
            this.myUi = ui;
        }

        public final void queryPlace(@NotNull Place place) {
            List commits = this.myUi.getVcsLog().getSelectedCommits();
            if (commits.size() > 0) {
                place.putPath(PLACE_KEY, commits.get(0));
            }
        }

        public final ActionCallback navigateTo(@Nullable Place place, final boolean requestFocus) {
            if (place == null) {
                return ActionCallback.DONE;
            }
            Object value = place.getPath(PLACE_KEY);
            if (!(value instanceof CommitId)) {
                return ActionCallback.REJECTED;
            }
            CommitId commitId = (CommitId)value;
            final ActionCallback callback2 = new ActionCallback();
            ListenableFuture<Boolean> future2 = this.myUi.jumpToCommit(commitId.getHash(), commitId.getRoot());
            Futures.addCallback(future2, (FutureCallback)new FutureCallback<Boolean>(){

                public void onSuccess(Boolean success2) {
                    if (success2.booleanValue()) {
                        if (requestFocus) {
                            myUi.getTable().requestFocusInWindow();
                        }
                        callback2.setDone();
                    } else {
                        callback2.setRejected();
                    }
                }

                public void onFailure(Throwable t) {
                    callback2.setRejected();
                }
            }, (Executor)EdtExecutorService.getInstance());
            return callback2;
        }
    }
}

