/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotVisiblePackBuilder {
    private static final int VISIBLE_RANGE = 1000;
    @NotNull
    private final VcsLogStorage myStorage;

    public SnapshotVisiblePackBuilder(@NotNull VcsLogStorage storage2) {
        this.myStorage = storage2;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        if (visiblePack.getVisibleGraph() instanceof VisibleGraphImpl && visiblePack.getVisibleGraph().getVisibleCommitCount() > 0) {
            return this.build(visiblePack.getDataPack(), (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters(), visiblePack.getAdditionalData());
        }
        VisibleGraph<Integer> newGraph = EmptyVisibleGraph.getInstance();
        DataPackBase newPack = new DataPackBase(visiblePack.getDataPack().getLogProviders(), this.createEmptyRefsModel(), false);
        return new VisiblePack(newPack, newGraph, true, visiblePack.getFilters());
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters, @Nullable Object data) {
        int visibleRow = 1000;
        int visibleRange = 1000;
        SimpleGraphInfo<Integer> info = oldGraph.buildSimpleGraphInfo(visibleRow, visibleRange);
        Set heads = ContainerUtil.map2Set(info.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph, oldPack.getLogProviders(), visibleRow, visibleRange);
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(newRefsModel, VcsLogStorageImpl.createHashGetter(this.myStorage), DataPack.getRefManagerMap(oldPack.getLogProviders()));
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info), info, null), info, colorManager);
        return new VisiblePack(newPack, newGraph, true, filters, data);
    }

    @NotNull
    private RefsModel createEmptyRefsModel() {
        return new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), this.myStorage, ContainerUtil.newHashMap());
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraphImpl<Integer> visibleGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, int visibleRow, int visibleRange) {
        HashSet branchesAndHeads = ContainerUtil.newHashSet();
        for (int row2 = Math.max(0, visibleRow - visibleRange); row2 < Math.min(visibleGraph.getLinearGraph().nodesCount(), visibleRow + visibleRange); ++row2) {
            Integer commit2 = (Integer)visibleGraph.getRowInfo(row2).getCommit();
            refsModel.refsToCommit(commit2).forEach(ref -> {
                if (ref.getType().isBranch() || heads.contains(commit2)) {
                    branchesAndHeads.add(ref);
                }
            });
        }
        Map<VirtualFile, Set<VcsRef>> map2 = VcsLogUtil.groupRefsByRoot(branchesAndHeads);
        HashMap refs = ContainerUtil.newHashMap();
        Iterator<VirtualFile> iterator = providers.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile root;
            Set<VcsRef> refsForRoot = map2.get(root = iterator.next());
            refs.put(root, new CompressedRefs((Set<VcsRef>)(refsForRoot == null ? ContainerUtil.newHashSet() : refsForRoot), this.myStorage));
        }
        return new RefsModel(refs, heads, this.myStorage, providers);
    }
}

