/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisiblePack
implements VcsLogDataPack {
    @NotNull
    public static final VisiblePack EMPTY = new VisiblePack((DataPackBase)DataPack.EMPTY, (VisibleGraph)EmptyVisibleGraph.getInstance(), false, VcsLogFilterCollectionImpl.EMPTY){

        @Override
        public String toString() {
            return "EmptyVisiblePack";
        }
    };
    @NotNull
    private final DataPackBase myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;
    @Nullable
    private final Object myAdditionalData;

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph2, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        this(dataPack, graph2, canRequestMore, filters, null);
    }

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph2, boolean canRequestMore, @NotNull VcsLogFilterCollection filters, @Nullable Object data) {
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph2;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters;
        this.myAdditionalData = data;
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        return this.myVisibleGraph;
    }

    @NotNull
    public DataPackBase getDataPack() {
        return this.myDataPack;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        return this.myDataPack.getLogProviders();
    }

    @NotNull
    public VcsLogRefs getRefs() {
        return this.myDataPack.getRefsModel();
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        return this.myFilters;
    }

    public boolean isEmpty() {
        return this.getVisibleGraph().getVisibleCommitCount() == 0;
    }

    public VirtualFile getRoot(int row2) {
        int head = (Integer)this.myVisibleGraph.getRowInfo(row2).getOneOfHeads();
        return this.myDataPack.getRefsModel().rootAtHead(head);
    }

    public <T> T getAdditionalData() {
        return (T)this.myAdditionalData;
    }

    public String toString() {
        return "VisiblePack{size=" + this.myVisibleGraph.getVisibleCommitCount() + ", filters=" + this.myFilters + ", canRequestMore=" + this.myCanRequestMore + "}";
    }
}

