/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.SnapshotVisiblePackBuilder;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VcsLogFiltererImplKt;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcs.log.visible.VisiblePackChangeListener;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Future;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class VisiblePackRefresherImpl
implements VisiblePackRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VisiblePackRefresherImpl.class);
    @NotNull
    private final String myLogId;
    @NotNull
    private final SingleTaskController<Request, State> myTaskController;
    @NotNull
    private final VcsLogFilterer myVcsLogFilterer;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogIndex.IndexingFinishedListener myIndexingFinishedListener;
    @NotNull
    private final List<VisiblePackChangeListener> myVisiblePackChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @NotNull
    private volatile State myState;

    public VisiblePackRefresherImpl(@NotNull Project project, @NotNull VcsLogData logData, @NotNull PermanentGraph.SortType initialSortType, @NotNull VcsLogFilterer builder2, @NotNull String logId) {
        this(project, logData, VcsLogFilterObject.collection(new VcsLogFilter[0]), initialSortType, builder2, logId);
    }

    public VisiblePackRefresherImpl(final @NotNull Project project, @NotNull VcsLogData logData, @NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterer filterer, @NotNull String logId) {
        this.myLogData = logData;
        this.myVcsLogFilterer = filterer;
        this.myLogId = logId;
        this.myState = new State(filters, sortType);
        this.myTaskController = new SingleTaskController<Request, State>(project, "visible " + StringUtil.trimMiddle((String)logId, (int)40), state -> {
            boolean hasChanges = this.myState.getVisiblePack() != state.getVisiblePack();
            this.myState = state;
            if (hasChanges) {
                for (VisiblePackChangeListener listener2 : this.myVisiblePackChangeListeners) {
                    listener2.onVisiblePackChange(state.getVisiblePack());
                }
            }
        }, true, (Disposable)this){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                ProgressIndicator indicator = VisiblePackRefresherImpl.this.myLogData.getProgress().createProgressIndicator(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, false));
                MyTask task2 = new MyTask(project, "Applying filters...");
                Future<?> future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(task2, indicator, null);
                return new SingleTaskController.SingleTaskImpl(future2, indicator);
            }
        };
        this.myIndexingFinishedListener = root -> this.myTaskController.request((Request[])new Request[]{new IndexingFinishedRequest(root)});
        this.myLogData.getIndex().addListener(this.myIndexingFinishedListener);
    }

    @Override
    public void addVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        this.myVisiblePackChangeListeners.add(listener2);
    }

    @Override
    public void removeVisiblePackChangeListener(@NotNull VisiblePackChangeListener listener2) {
        this.myVisiblePackChangeListeners.remove(listener2);
    }

    @Override
    public void onRefresh() {
        this.myTaskController.request((Request[])new Request[]{new RefreshRequest()});
    }

    @Override
    public void setValid(boolean validate2, boolean refresh2) {
        if (refresh2) {
            this.myTaskController.request((Request[])new Request[]{new RefreshRequest(), new ValidateRequest(validate2)});
        } else {
            this.myTaskController.request((Request[])new Request[]{new ValidateRequest(validate2)});
        }
    }

    @Override
    public void onFiltersChange(@NotNull VcsLogFilterCollection newFilters) {
        this.myTaskController.request((Request[])new Request[]{new FilterRequest(newFilters)});
    }

    @Override
    public void onSortTypeChange(@NotNull PermanentGraph.SortType sortType) {
        this.myTaskController.request((Request[])new Request[]{new SortTypeRequest(sortType)});
    }

    @Override
    public void moreCommitsNeeded(@NotNull Runnable onLoaded) {
        this.myTaskController.request((Request[])new Request[]{new MoreCommitsRequest(onLoaded)});
    }

    @Override
    public boolean isValid() {
        return this.myState.isValid();
    }

    public String toString() {
        return "VisiblePackRefresher '" + this.myLogId + "' state = " + this.myState;
    }

    public void dispose() {
        this.myLogData.getIndex().removeListener(this.myIndexingFinishedListener);
    }

    public static boolean isVisibleKeyFor(@NotNull VcsLogProgress.ProgressKey key, @NotNull String logId) {
        if (key instanceof VisiblePackProgressKey) {
            VisiblePackProgressKey visiblePackProgressKey = (VisiblePackProgressKey)key;
            return visiblePackProgressKey.getLogId().equals(logId) && visiblePackProgressKey.isVisible();
        }
        return false;
    }

    public static class VisiblePackProgressKey
    extends VcsLogProgress.ProgressKey {
        @NotNull
        private final String myLogId;
        private final boolean myVisible;

        public VisiblePackProgressKey(@NotNull String logId, boolean visible) {
            super("visible pack for " + logId);
            this.myLogId = logId;
            this.myVisible = visible;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        @NotNull
        public String getLogId() {
            return this.myLogId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VisiblePackProgressKey key = (VisiblePackProgressKey)o;
            return this.myVisible == key.myVisible && Objects.equals(this.myLogId, key.myLogId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.myLogId, this.myVisible);
        }
    }

    private static final class IndexingFinishedRequest
    implements Request {
        @NotNull
        private final VirtualFile root;

        IndexingFinishedRequest(@NotNull VirtualFile root) {
            this.root = root;
        }

        @NotNull
        public VirtualFile getRoot() {
            return this.root;
        }

        public String toString() {
            return "IndexingFinishedRequest for " + this.root;
        }
    }

    private static final class MoreCommitsRequest
    implements Request {
        @NotNull
        private final Runnable onLoaded;

        MoreCommitsRequest(@NotNull Runnable onLoaded) {
            this.onLoaded = onLoaded;
        }
    }

    private static final class SortTypeRequest
    implements Request {
        private final PermanentGraph.SortType sortType;

        SortTypeRequest(PermanentGraph.SortType sortType) {
            this.sortType = sortType;
        }

        public String toString() {
            return "SortTypeRequest " + this.sortType;
        }
    }

    private static final class FilterRequest
    implements Request {
        private final VcsLogFilterCollection filters;

        FilterRequest(VcsLogFilterCollection filters) {
            this.filters = filters;
        }

        public String toString() {
            return "FilterRequest by " + this.filters;
        }
    }

    private static final class ValidateRequest
    implements Request {
        private final boolean validate;

        private ValidateRequest(boolean validate2) {
            this.validate = validate2;
        }

        public String toString() {
            return "ValidateRequest " + this.validate;
        }
    }

    private static final class RefreshRequest
    implements Request {
        private RefreshRequest() {
        }

        public String toString() {
            return "RefreshRequest";
        }
    }

    private static interface Request {
    }

    private static class State {
        @NotNull
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final PermanentGraph.SortType mySortType;
        @NotNull
        private final CommitCountStage myCommitCount;
        @NotNull
        private final List<MoreCommitsRequest> myRequestsToRun;
        @NotNull
        private final VisiblePack myVisiblePack;
        private final boolean myIsValid;

        State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType) {
            this(filters, sortType, CommitCountStage.INITIAL, ContainerUtil.newArrayList(), VisiblePack.EMPTY, true);
        }

        State(@NotNull VcsLogFilterCollection filters, @NotNull PermanentGraph.SortType sortType, @NotNull CommitCountStage commitCountStage, @NotNull List<MoreCommitsRequest> requests, @NotNull VisiblePack visiblePack, boolean isValid) {
            this.myFilters = filters;
            this.mySortType = sortType;
            this.myCommitCount = commitCountStage;
            this.myRequestsToRun = Collections.unmodifiableList(requests);
            this.myVisiblePack = visiblePack;
            this.myIsValid = isValid;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        @NotNull
        public VisiblePack getVisiblePack() {
            return this.myVisiblePack;
        }

        @NotNull
        public List<MoreCommitsRequest> getRequestsToRun() {
            return this.myRequestsToRun;
        }

        @NotNull
        public VcsLogFilterCollection getFilters() {
            return this.myFilters;
        }

        @NotNull
        public PermanentGraph.SortType getSortType() {
            return this.mySortType;
        }

        @NotNull
        public CommitCountStage getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        public State withValid(boolean valid) {
            return new State(this.myFilters, this.mySortType, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, valid);
        }

        @NotNull
        public State withVisiblePack(@NotNull VisiblePack visiblePack) {
            return new State(this.myFilters, this.mySortType, this.myCommitCount, this.myRequestsToRun, visiblePack, this.myIsValid);
        }

        @NotNull
        public State withCommitCount(@NotNull CommitCountStage commitCount) {
            return new State(this.myFilters, this.mySortType, commitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withRequests(@NotNull List<MoreCommitsRequest> requests) {
            return new State(this.myFilters, this.mySortType, this.myCommitCount, requests, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withFilters(@NotNull VcsLogFilterCollection filters) {
            return new State(filters, this.mySortType, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        @NotNull
        public State withSortType(@NotNull PermanentGraph.SortType type) {
            return new State(this.myFilters, type, this.myCommitCount, this.myRequestsToRun, this.myVisiblePack, this.myIsValid);
        }

        public String toString() {
            return "State{myFilters=" + this.myFilters + ", mySortType=" + this.mySortType + ", myCommitCount=" + (Object)((Object)this.myCommitCount) + ", myRequestsToRun=" + this.myRequestsToRun + ", myVisiblePack=" + this.myVisiblePack + ", myIsValid=" + this.myIsValid + '}';
        }
    }

    private class MyTask
    extends Task.Backgroundable {
        MyTask(@NotNull Project project, String title) {
            super(project, title, false);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            State state = VisiblePackRefresherImpl.this.myState;
            List requests = VisiblePackRefresherImpl.this.myTaskController.peekRequests();
            if (!requests.isEmpty()) {
                try {
                    state = this.computeState(state, requests);
                    VisiblePackRefresherImpl.this.myTaskController.removeRequests(requests);
                }
                catch (ProcessCanceledException reThrown) {
                    LOG.debug("Filtering cancelled");
                    VisiblePackRefresherImpl.this.myTaskController.taskCompleted(null);
                    throw reThrown;
                }
                catch (Throwable t) {
                    LOG.error("Error while filtering log by " + requests, t);
                }
            }
            ArrayList requestsToRun = ContainerUtil.newArrayList();
            if (state.getVisiblePack() != VisiblePackRefresherImpl.this.myState.getVisiblePack() && state.isValid()) {
                requestsToRun.addAll(state.getRequestsToRun());
                state = state.withRequests(ContainerUtil.newArrayList());
            }
            VisiblePackRefresherImpl.this.myTaskController.taskCompleted(state);
            if (!requestsToRun.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (MoreCommitsRequest request : requestsToRun) {
                        request.onLoaded.run();
                    }
                });
            }
        }

        @NotNull
        private State computeState(@NotNull State state, @NotNull List<? extends Request> requests) {
            ValidateRequest validateRequest = (ValidateRequest)ContainerUtil.findLastInstance(requests, ValidateRequest.class);
            FilterRequest filterRequest = (FilterRequest)ContainerUtil.findLastInstance(requests, FilterRequest.class);
            SortTypeRequest sortTypeRequest = (SortTypeRequest)ContainerUtil.findLastInstance(requests, SortTypeRequest.class);
            List moreCommitsRequests = ContainerUtil.findAll(requests, MoreCommitsRequest.class);
            List indexingRequests = ContainerUtil.findAll(requests, IndexingFinishedRequest.class);
            state = state.withRequests(ContainerUtil.concat(state.getRequestsToRun(), (List)moreCommitsRequests));
            if (filterRequest != null) {
                state = state.withFilters(filterRequest.filters);
            }
            if (sortTypeRequest != null) {
                state = state.withSortType(sortTypeRequest.sortType);
            }
            if (!state.isValid()) {
                if (validateRequest != null && validateRequest.validate) {
                    state = state.withValid(true);
                    return this.refresh(state, filterRequest != null, moreCommitsRequests);
                }
                return state;
            }
            if (validateRequest != null && !validateRequest.validate) {
                state = state.withValid(false);
                if (filterRequest != null) {
                    state = this.refresh(state, true, moreCommitsRequests);
                }
                return state.withVisiblePack(new SnapshotVisiblePackBuilder(VisiblePackRefresherImpl.this.myLogData.getStorage()).build(state.getVisiblePack()));
            }
            boolean indexingFinished = !indexingRequests.isEmpty() && VcsLogFiltererImplKt.areFiltersAffectedByIndexing(state.getFilters(), ContainerUtil.map((Collection)indexingRequests, IndexingFinishedRequest::getRoot));
            Request nonValidateRequest = (Request)ContainerUtil.find(requests, request -> !(request instanceof ValidateRequest) && !(request instanceof IndexingFinishedRequest));
            if (nonValidateRequest != null || indexingFinished) {
                return this.refresh(state, filterRequest != null, moreCommitsRequests);
            }
            return state;
        }

        @NotNull
        private State refresh(@NotNull State state, boolean resetCommitCount, @NotNull List<MoreCommitsRequest> moreCommitsRequests) {
            DataPack dataPack = VisiblePackRefresherImpl.this.myLogData.getDataPack();
            if (dataPack == DataPack.EMPTY && !VisiblePackRefresherImpl.this.myVcsLogFilterer.canFilterEmptyPack(state.getFilters())) {
                return state;
            }
            if (resetCommitCount) {
                state = state.withCommitCount(CommitCountStage.INITIAL);
            } else if (!moreCommitsRequests.isEmpty()) {
                state = state.withCommitCount(state.getCommitCount().next());
            }
            VcsLogProgress.updateCurrentKey(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, resetCommitCount || state.getVisiblePack().getDataPack() != dataPack || moreCommitsRequests.isEmpty()));
            Pair<VisiblePack, CommitCountStage> pair = VisiblePackRefresherImpl.this.myVcsLogFilterer.filter(dataPack, state.getSortType(), state.getFilters(), state.getCommitCount());
            VcsLogProgress.updateCurrentKey(new VisiblePackProgressKey(VisiblePackRefresherImpl.this.myLogId, false));
            return state.withVisiblePack((VisiblePack)pair.getFirst()).withCommitCount((CommitCountStage)((Object)pair.getSecond()));
        }
    }
}

