/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogUserFilterImpl.class);
    @NotNull
    public static final String ME = "me";
    @NotNull
    private final Collection<String> myUsers;
    @NotNull
    private final Map<VirtualFile, VcsUser> myData;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByNames = MultiMap.create();
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByEmails = MultiMap.create();

    VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<? extends VcsUser> allUsers) {
        this.myUsers = users;
        this.myData = meData;
        for (VcsUser vcsUser : allUsers) {
            String email;
            String nameFromEmail;
            String name = vcsUser.getName();
            if (!name.isEmpty()) {
                this.myAllUsersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm(name), (Object)vcsUser);
            }
            if ((nameFromEmail = VcsUserUtil.getNameFromEmail(email = vcsUser.getEmail())) == null) continue;
            this.myAllUsersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm(nameFromEmail), (Object)vcsUser);
        }
    }

    @NotNull
    public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
        HashSet result2 = ContainerUtil.newHashSet();
        for (String user : this.myUsers) {
            result2.addAll(this.getUsers(root, user));
        }
        return result2;
    }

    @NotNull
    private Set<VcsUser> getUsers(@NotNull VirtualFile root, @NotNull String name) {
        HashSet users = ContainerUtil.newHashSet();
        if (ME.equals(name)) {
            VcsUser vcsUser = this.myData.get(root);
            if (vcsUser != null) {
                users.addAll(this.getUsers(vcsUser.getName()));
                String emailNamePart = VcsUserUtil.getNameFromEmail(vcsUser.getEmail());
                if (emailNamePart != null) {
                    users.addAll(this.getUsers(emailNamePart));
                }
            } else {
                LOG.warn("Can not resolve user name for root " + root);
            }
        } else {
            users.addAll(this.getUsers(name));
        }
        return users;
    }

    @NotNull
    public Collection<String> getUserNamesForPresentation() {
        return this.myUsers;
    }

    public boolean matches(@NotNull VcsCommitMetadata commit2) {
        return ContainerUtil.exists(this.myUsers, name -> {
            Set<VcsUser> users = this.getUsers(commit2.getRoot(), (String)name);
            if (!users.isEmpty()) {
                return users.contains(commit2.getAuthor());
            }
            if (!name.equals(ME)) {
                boolean result2;
                String lowerUser = VcsUserUtil.nameToLowerCase(name);
                boolean bl = result2 = VcsUserUtil.nameToLowerCase(commit2.getAuthor().getName()).equals(lowerUser) || VcsUserUtil.emailToLowerCase(commit2.getAuthor().getEmail()).startsWith(lowerUser + "@");
                if (result2) {
                    LOG.warn("Unregistered author " + commit2.getAuthor() + " for commit " + ((Hash)commit2.getId()).asString() + "; search pattern " + name);
                }
                return result2;
            }
            return false;
        });
    }

    private Set<VcsUser> getUsers(@NotNull String name) {
        HashSet result2 = ContainerUtil.newHashSet();
        result2.addAll(this.myAllUsersByNames.get((Object)VcsUserUtil.getNameInStandardForm(name)));
        result2.addAll(this.myAllUsersByEmails.get((Object)VcsUserUtil.getNameInStandardForm(name)));
        return result2;
    }

    @NotNull
    public String getPresentation() {
        return StringUtil.join(this.getUserNamesForPresentation(), (String)", ");
    }

    public String toString() {
        return "author: " + StringUtil.join(this.myUsers, (String)", ");
    }
}

