/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class RollbackUtil {
    private RollbackUtil() {
    }

    @NotNull
    public static String getRollbackOperationName(@NotNull Collection<? extends AbstractVcs> vcses) {
        String operationName = null;
        for (AbstractVcs abstractVcs : vcses) {
            RollbackEnvironment rollbackEnvironment = abstractVcs.getRollbackEnvironment();
            if (rollbackEnvironment == null) continue;
            if (operationName == null) {
                operationName = rollbackEnvironment.getRollbackOperationName();
                continue;
            }
            if (operationName.equals(rollbackEnvironment.getRollbackOperationName())) continue;
            return DefaultRollbackEnvironment.ROLLBACK_OPERATION_NAME;
        }
        return operationName != null ? operationName : DefaultRollbackEnvironment.ROLLBACK_OPERATION_NAME;
    }

    @NotNull
    public static String getRollbackOperationName(@NotNull Project project) {
        return RollbackUtil.getRollbackOperationName(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()));
    }
}

