/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableNotNullFunction<? super List<String>, ? extends List<? extends T>, ? extends VcsException> processor2) throws VcsException {
        ArrayList result2 = ContainerUtil.newArrayList();
        VcsFileUtil.foreachChunk(arguments, groupSize, (ThrowableConsumer<? super List<String>, ? extends VcsException>)((ThrowableConsumer)chunk -> result2.addAll((Collection)processor2.fun(chunk))));
        return result2;
    }

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<? super List<String>, ? extends VcsException> consumer) throws VcsException {
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
            }
            consumer.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        return VcsFileUtil.chunkArguments(arguments, 1);
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i;
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start2 = 0;
        int size = 0;
        for (i = 0; i < arguments.size(); i += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i + j).length();
            }
            if (size + length > 7600) {
                if (start2 == i) {
                    rc.add(arguments.subList(i, i + groupSize));
                    start2 = i + groupSize;
                    size = 0;
                    continue;
                }
                rc.add(arguments.subList(start2, i));
                start2 = i;
                size = length;
                continue;
            }
            size += length;
        }
        if (start2 != arguments.size()) {
            rc.add(arguments.subList(start2, i));
        }
        return rc;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<? extends FilePath> files2) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root, files2));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files2) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root, files2));
    }

    public static String getRelativeFilePath(VirtualFile file2, @NotNull VirtualFile baseDir) {
        return VcsFileUtil.getRelativeFilePath(file2.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file2, @NotNull VirtualFile baseDir) {
        String basePath;
        if (SystemInfo.isWindows) {
            file2 = file2.replace('\\', '/');
        }
        if (!file2.startsWith(basePath = baseDir.getPath())) {
            return file2;
        }
        if (file2.equals(basePath)) {
            return ".";
        }
        return file2.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return VcsFileUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file2) {
        return VcsFileUtil.relativePath(root, VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(VirtualFile root, VirtualFile file2) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file2) {
        if (root == null) {
            file2.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) {
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath filePath : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, filePath));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files2) {
        ArrayList<String> rc = new ArrayList<String>(files2.size());
        for (VirtualFile virtualFile : files2) {
            rc.add(VcsFileUtil.relativePath(root, virtualFile));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<? extends VirtualFile> affectedFiles2) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile virtualFile : affectedFiles2) {
            if (virtualFile.isDirectory()) {
                dirty.dirDirtyRecursively(virtualFile);
                continue;
            }
            dirty.fileDirty(virtualFile);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<? extends FilePath> affectedFiles2) {
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath filePath : affectedFiles2) {
            if (filePath.isDirectory()) {
                dirty.dirDirtyRecursively(filePath);
                continue;
            }
            dirty.fileDirty(filePath);
        }
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, VirtualFile ... virtualFiles) {
        VcsFileUtil.addFilesToVcsWithConfirmation(project, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile virtualFile : virtualFiles) {
            AbstractVcs vcs = vcsManager.getVcsFor(virtualFile);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)virtualFile, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$1((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs abstractVcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, abstractVcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(vcsMap.get((Object)abstractVcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(abstractVcs, filesList);
                continue;
            }
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(abstractVcs, new ArrayList<VirtualFile>((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<VirtualFile> value) {
        CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
        if (checkinEnvironment != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value);
        }
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$1(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile) {
        return vcsMap.put((Object)vcs, (Object)virtualFile);
    }
}

