/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public class VcsImplUtil {
    private static final Logger LOG = Logger.getInstance(VcsImplUtil.class);
    public static final String MANAGE_IGNORE_FILES_PROPERTY = "MANAGE_IGNORE_FILES_PROPERTY";

    public static void showErrorMessage(Project project, String message, String title) {
        Runnable task2 = () -> Messages.showErrorDialog((Project)project, (String)message, (String)title);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task2, null, (Project)project);
    }

    @NotNull
    public static String getShortVcsRootName(@NotNull Project project, @NotNull VirtualFile root) {
        String relativePath;
        VirtualFile projectDir = project.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        return repositoryPath.isEmpty() ? root.getName() : repositoryPath;
    }

    public static boolean isNonModalCommit() {
        return Registry.is((String)"vcs.non.modal.commit");
    }

    public static void proposeUpdateIgnoreFile(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        if (!Registry.is((String)"vcs.ignorefile.generation", (boolean)true)) {
            return;
        }
        IgnoredFileContentProvider ignoreContentProvider = VcsImplUtil.getIgnoredFileContentProvider(project, vcs);
        if (ignoreContentProvider == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        String ignoreFileName = ignoreContentProvider.getFileName();
        File ignoreFile = Paths.get(ignoreFileRoot.getPath(), ignoreFileName).toFile();
        if (VcsImplUtil.canManageIgnoreFiles(project)) {
            VcsImplUtil.updateIgnoreFileIfNeeded(project, vcs, ignoreFileRoot, ignoreFile.exists());
        } else {
            VcsImplUtil.notifyVcsIgnoreFileManage(project, () -> VcsImplUtil.updateIgnoreFileAndOpen(project, vcs, ignoreFileRoot, ignoreFile));
        }
    }

    private static void notifyVcsIgnoreFileManage(@NotNull Project project, @NotNull Runnable manageIgnore) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        VcsNotifier.getInstance(project).notifyMinorInfo("", VcsBundle.message((String)"ignored.file.manage.message", (Object[])new Object[0]), NotificationAction.create((String)VcsBundle.message((String)"ignored.file.manage.this.project", (Object[])new Object[0]), (event, notification) -> {
            manageIgnore.run();
            propertiesComponent.setValue(MANAGE_IGNORE_FILES_PROPERTY, true);
            notification.expire();
        }), NotificationAction.create((String)VcsBundle.message((String)"ignored.file.manage.all.project", (Object[])new Object[0]), (event, notification) -> {
            manageIgnore.run();
            applicationSettings.MANAGE_IGNORE_FILES = true;
            notification.expire();
        }), NotificationAction.create((String)VcsBundle.message((String)"ignored.file.manage.notnow", (Object[])new Object[0]), (event, notification) -> notification.expire()));
    }

    public static boolean generateIgnoreFileIfNeeded(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        return VcsImplUtil.updateIgnoreFileIfNeeded(project, vcs, ignoreFileRoot, false);
    }

    public static boolean updateIgnoreFileIfNeeded(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, boolean append) {
        if (!Registry.is((String)"vcs.ignorefile.generation", (boolean)true)) {
            return false;
        }
        IgnoredFileGenerator ignoredFileGenerator = (IgnoredFileGenerator)ServiceManager.getService((Project)project, IgnoredFileGenerator.class);
        if (ignoredFileGenerator == null) {
            LOG.debug("Cannot find ignore file ignoredFileGenerator for " + vcs.getName() + " VCS");
            return false;
        }
        try {
            return append ? ignoredFileGenerator.appendFile(ignoreFileRoot, vcs) : ignoredFileGenerator.generateFile(ignoreFileRoot, vcs);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static void updateIgnoreFileAndOpen(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, @NotNull File ignoreFile) {
        if (VcsImplUtil.updateIgnoreFileIfNeeded(project, vcs, ignoreFileRoot, ignoreFile.exists())) {
            VirtualFile ignoreVFile = VfsUtil.findFileByIoFile((File)ignoreFile, (boolean)true);
            if (ignoreVFile == null) {
                return;
            }
            new OpenFileDescriptor(project, ignoreVFile).navigate(true);
        }
    }

    private static IgnoredFileContentProvider getIgnoredFileContentProvider(@NotNull Project project, @NotNull AbstractVcs vcs) {
        return IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions((AreaInstance)project).filter(provider -> provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())).findFirst().orElse(null);
    }

    public static boolean canManageIgnoreFiles(@NotNull Project project) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        return applicationSettings.MANAGE_IGNORE_FILES || propertiesComponent.getBoolean(MANAGE_IGNORE_FILES_PROPERTY, false);
    }

    private static boolean isFileSharedInVcs(@NotNull Project project, @NotNull ChangeListManagerEx changeListManager, @NotNull String filePath) {
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file2 == null) {
            return false;
        }
        FileStatus fileStatus = changeListManager.getStatus(file2);
        return VcsUtil.isFileUnderVcs((Project)project, (String)filePath) && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED;
    }

    public static boolean isProjectSharedInVcs(@NotNull Project project) {
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return false;
            }
            @SystemIndependent String projectFilePath = project.getProjectFilePath();
            ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
            return !changeListManager.isInUpdate() && projectFilePath != null && VcsImplUtil.isFileSharedInVcs(project, changeListManager, projectFilePath);
        });
    }
}

