/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.fs.LazyAttachVirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyAttachVirtualFS
extends VirtualFileSystem {
    private static final Logger LOG = Logger.getInstance(LazyAttachVirtualFS.class);
    @NonNls
    private static final String PROTOCOL = "lazyAttachVfs";
    private final Map<String, LazyAttachVirtualFile> myFileCache = new HashMap<String, LazyAttachVirtualFile>();

    public static LazyAttachVirtualFS getInstance() {
        return (LazyAttachVirtualFS)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path, @NotNull EnvironmentAwareHost hostInfo) {
        String fullFilePath = hostInfo.getFileSystemHostId() + path;
        return (VirtualFile)this.myFileCache.computeIfAbsent(fullFilePath, s -> {
            String content;
            try {
                content = LazyAttachVirtualFS.getFileContent(hostInfo, path);
            }
            catch (IOException e) {
                LOG.warn("can't read file", (Throwable)e);
                return null;
            }
            if (content == null) {
                return null;
            }
            return new LazyAttachVirtualFile(fullFilePath, content);
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        return (VirtualFile)this.myFileCache.get(path);
    }

    public void refresh(boolean asynchronous) {
        throw new IncorrectOperationException();
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return null;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
    }

    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) {
        throw new IncorrectOperationException();
    }

    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        throw new IncorrectOperationException();
    }

    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName2) {
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) {
        throw new IncorrectOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    private static String getFileContent(@NotNull EnvironmentAwareHost host, @NotNull String path) throws IOException {
        InputStream stream = host.getFileContent(path);
        if (stream == null) {
            return null;
        }
        return new String(FileUtil.loadBytes((InputStream)stream), StandardCharsets.UTF_8);
    }
}

