/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUsageCollector;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointListener;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionImpl
implements XDebugSession {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.XDebugSessionImpl");
    @Deprecated
    public static final NotificationGroup NOTIFICATION_GROUP = XDebuggerManagerImpl.NOTIFICATION_GROUP;
    private XDebugProcess myDebugProcess;
    private final Map<XBreakpoint<?>, CustomizedBreakpointPresentation> myRegisteredBreakpoints = new THashMap();
    private final Set<XBreakpoint<?>> myInactiveSlaveBreakpoints = Collections.synchronizedSet(new SmartHashSet());
    private boolean myBreakpointsDisabled;
    private final XDebuggerManagerImpl myDebuggerManager;
    private Disposable myBreakpointListenerDisposable;
    private XSuspendContext mySuspendContext;
    private XExecutionStack myCurrentExecutionStack;
    private XStackFrame myCurrentStackFrame;
    private boolean myIsTopFrame;
    private volatile XSourcePosition myTopFramePosition;
    private final AtomicBoolean myPaused = new AtomicBoolean();
    private XValueMarkers<?, ?> myValueMarkers;
    private final String mySessionName;
    @Nullable
    private XDebugSessionTab mySessionTab;
    @NotNull
    private final XDebugSessionData mySessionData;
    private XBreakpoint<?> myActiveNonLineBreakpoint;
    private final EventDispatcher<XDebugSessionListener> myDispatcher = EventDispatcher.create(XDebugSessionListener.class);
    private final Project myProject;
    @Nullable
    private final ExecutionEnvironment myEnvironment;
    private final AtomicBoolean myStopped = new AtomicBoolean();
    private boolean myPauseActionSupported;
    private boolean myReadOnly = false;
    private final AtomicBoolean myShowTabOnSuspend;
    private final List<AnAction> myRestartActions = new SmartList();
    private final List<AnAction> myExtraStopActions = new SmartList();
    private final List<AnAction> myExtraActions = new SmartList();
    private ConsoleView myConsoleView;
    private final Icon myIcon;
    private volatile boolean breakpointsInitialized;

    public XDebugSessionImpl(@NotNull ExecutionEnvironment environment, @NotNull XDebuggerManagerImpl debuggerManager) {
        this(environment, debuggerManager, environment.getRunProfile().getName(), environment.getRunProfile().getIcon(), false, null);
    }

    public XDebugSessionImpl(@Nullable ExecutionEnvironment environment, @NotNull XDebuggerManagerImpl debuggerManager, @NotNull String sessionName, @Nullable Icon icon, boolean showTabOnSuspend, @Nullable RunContentDescriptor contentToReuse) {
        JComponent component;
        this.myEnvironment = environment;
        this.mySessionName = sessionName;
        this.myDebuggerManager = debuggerManager;
        this.myShowTabOnSuspend = new AtomicBoolean(showTabOnSuspend);
        this.myProject = debuggerManager.getProject();
        ValueLookupManager.getInstance(this.myProject).startListening();
        this.myIcon = icon;
        XDebugSessionData oldSessionData = null;
        if (contentToReuse == null) {
            RunContentDescriptor runContentDescriptor = contentToReuse = environment != null ? environment.getContentToReuse() : null;
        }
        if (contentToReuse != null && (component = contentToReuse.getComponent()) != null) {
            oldSessionData = (XDebugSessionData)((Object)XDebugSessionData.DATA_KEY.getData(DataManager.getInstance().getDataContext((Component)component)));
        }
        String currentConfigurationName = this.getConfigurationName();
        if (oldSessionData == null || !oldSessionData.getConfigurationName().equals(currentConfigurationName)) {
            oldSessionData = new XDebugSessionData(this.getWatchExpressions(), currentConfigurationName);
        }
        this.mySessionData = oldSessionData;
    }

    @NotNull
    public String getSessionName() {
        return this.mySessionName;
    }

    @NotNull
    public RunContentDescriptor getRunContentDescriptor() {
        this.assertSessionTabInitialized();
        return this.mySessionTab.getRunContentDescriptor();
    }

    private void assertSessionTabInitialized() {
        if (this.myShowTabOnSuspend.get()) {
            LOG.error("Debug tool window isn't shown yet because debug process isn't suspended");
        } else {
            LOG.assertTrue(this.mySessionTab != null, (Object)"Debug tool window not initialized yet!");
        }
    }

    public void setPauseActionSupported(boolean isSupported) {
        this.myPauseActionSupported = isSupported;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    @NotNull
    public List<AnAction> getRestartActions() {
        return this.myRestartActions;
    }

    public void addRestartActions(AnAction ... restartActions) {
        if (restartActions != null) {
            Collections.addAll(this.myRestartActions, restartActions);
        }
    }

    @NotNull
    public List<AnAction> getExtraActions() {
        return this.myExtraActions;
    }

    public void addExtraActions(AnAction ... extraActions) {
        if (extraActions != null) {
            Collections.addAll(this.myExtraActions, extraActions);
        }
    }

    public List<AnAction> getExtraStopActions() {
        return this.myExtraStopActions;
    }

    public void addExtraStopActions(AnAction ... extraStopActions) {
        if (extraStopActions != null) {
            Collections.addAll(this.myExtraStopActions, extraStopActions);
        }
    }

    public void rebuildViews() {
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).settingsChanged();
    }

    @Nullable
    public RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public boolean isPauseActionSupported() {
        return this.myPauseActionSupported;
    }

    @NotNull
    public Project getProject() {
        return this.myDebuggerManager.getProject();
    }

    @NotNull
    public XDebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    public boolean isSuspended() {
        return this.myPaused.get() && this.mySuspendContext != null;
    }

    public boolean isPaused() {
        return this.myPaused.get();
    }

    @Nullable
    public XStackFrame getCurrentStackFrame() {
        return this.myCurrentStackFrame;
    }

    public XExecutionStack getCurrentExecutionStack() {
        return this.myCurrentExecutionStack;
    }

    public XSuspendContext getSuspendContext() {
        return this.mySuspendContext;
    }

    @Nullable
    public XSourcePosition getCurrentPosition() {
        return this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
    }

    @Nullable
    public XSourcePosition getTopFramePosition() {
        return this.myTopFramePosition;
    }

    void init(@NotNull XDebugProcess process2, @Nullable RunContentDescriptor contentToReuse) {
        LOG.assertTrue(this.myDebugProcess == null);
        this.myDebugProcess = process2;
        if (this.myDebugProcess.checkCanInitBreakpoints()) {
            this.initBreakpoints();
        }
        this.myDebugProcess.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                XDebugSessionImpl.this.stopImpl();
                XDebugSessionImpl.this.myDebugProcess.getProcessHandler().removeProcessListener((ProcessListener)this);
            }
        });
        this.myConsoleView = (ConsoleView)this.myDebugProcess.createConsole();
        if (!this.myShowTabOnSuspend.get()) {
            this.initSessionTab(contentToReuse);
        }
    }

    public void reset() {
        this.breakpointsInitialized = false;
        this.removeBreakpointListeners();
        this.unsetPaused();
        this.clearPausedData();
        this.rebuildViews();
    }

    public void initBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(!this.breakpointsInitialized);
        this.breakpointsInitialized = true;
        this.disableSlaveBreakpoints();
        this.processAllBreakpoints(true, false);
        if (this.myBreakpointListenerDisposable == null) {
            this.myBreakpointListenerDisposable = Disposer.newDisposable();
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect(this.myBreakpointListenerDisposable);
            busConnection.subscribe(XBreakpointListener.TOPIC, (Object)new MyBreakpointListener());
            busConnection.subscribe(XDependentBreakpointListener.TOPIC, (Object)new MyDependentBreakpointListener());
        }
    }

    public ConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    @Nullable
    public XDebugSessionTab getSessionTab() {
        return this.mySessionTab;
    }

    public RunnerLayoutUi getUI() {
        this.assertSessionTabInitialized();
        assert (this.mySessionTab != null);
        return this.mySessionTab.getUi();
    }

    private void initSessionTab(@Nullable RunContentDescriptor contentToReuse) {
        this.mySessionTab = XDebugSessionTab.create(this, this.myIcon, this.myEnvironment, contentToReuse);
        this.myDebugProcess.sessionInitialized();
        this.addSessionListener(new XDebugSessionListener(){

            public void sessionPaused() {
                this.updateActions();
            }

            public void sessionResumed() {
                this.updateActions();
            }

            public void sessionStopped() {
                this.updateActions();
            }

            public void stackFrameChanged() {
                this.updateActions();
            }

            private void updateActions() {
                UIUtil.invokeLaterIfNeeded(() -> XDebugSessionImpl.this.mySessionTab.getUi().updateActionsNow());
            }
        });
    }

    @NotNull
    public XDebugSessionData getSessionData() {
        return this.mySessionData;
    }

    private void disableSlaveBreakpoints() {
        Set<XBreakpoint<?>> slaveBreakpoints = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager().getAllSlaveBreakpoints();
        if (slaveBreakpoints.isEmpty()) {
            return;
        }
        THashSet breakpointTypes = new THashSet();
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            breakpointTypes.add(XDebugSessionImpl.getBreakpointTypeClass(handler2));
        }
        for (XBreakpoint xBreakpoint : slaveBreakpoints) {
            if (!breakpointTypes.contains(xBreakpoint.getType())) continue;
            this.myInactiveSlaveBreakpoints.add(xBreakpoint);
        }
    }

    public void showSessionTab() {
        RunContentDescriptor descriptor = this.getRunContentDescriptor();
        ExecutionManager.getInstance((Project)this.getProject()).getContentManager().showRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
    }

    @Nullable
    public XValueMarkers<?, ?> getValueMarkers() {
        XValueMarkerProvider provider;
        if (this.myValueMarkers == null && (provider = this.myDebugProcess.createValueMarkerProvider()) != null) {
            this.myValueMarkers = XValueMarkers.createValueMarkers(provider);
        }
        return this.myValueMarkers;
    }

    private static XBreakpointType getBreakpointTypeClass(XBreakpointHandler handler2) {
        return XDebuggerUtil.getInstance().findBreakpointType(handler2.getBreakpointTypeClass());
    }

    private <B extends XBreakpoint<?>> void processBreakpoints(XBreakpointHandler<B> handler2, boolean register, boolean temporary) {
        Collection breakpoints = this.myDebuggerManager.getBreakpointManager().getBreakpoints(handler2.getBreakpointTypeClass());
        for (XBreakpoint b : breakpoints) {
            this.handleBreakpoint(handler2, b, register, temporary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <B extends XBreakpoint<?>> void handleBreakpoint(XBreakpointHandler<B> handler2, B b, boolean register, boolean temporary) {
        if (register) {
            boolean active = (Boolean)ReadAction.compute(() -> this.isBreakpointActive(b));
            if (active) {
                Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
                synchronized (map2) {
                    this.myRegisteredBreakpoints.put(b, new CustomizedBreakpointPresentation());
                    if (b instanceof XLineBreakpoint) {
                        this.updateBreakpointPresentation((XLineBreakpoint)b, b.getType().getPendingIcon(), null);
                    }
                }
                handler2.registerBreakpoint(b);
            }
        } else {
            boolean removed;
            Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map3 = this.myRegisteredBreakpoints;
            synchronized (map3) {
                removed = this.myRegisteredBreakpoints.remove(b) != null;
            }
            if (removed) {
                handler2.unregisterBreakpoint(b, temporary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CustomizedBreakpointPresentation getBreakpointPresentation(@NotNull XBreakpoint<?> breakpoint) {
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
        synchronized (map2) {
            return this.myRegisteredBreakpoints.get(breakpoint);
        }
    }

    private void processAllHandlers(XBreakpoint<?> breakpoint, boolean register) {
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoint(breakpoint, handler2, register);
        }
    }

    private <B extends XBreakpoint<?>> void processBreakpoint(XBreakpoint<?> breakpoint, XBreakpointHandler<B> handler2, boolean register) {
        XBreakpointType type = breakpoint.getType();
        if (handler2.getBreakpointTypeClass().equals(type.getClass())) {
            XBreakpoint<?> b = breakpoint;
            this.handleBreakpoint(handler2, b, register, false);
        }
    }

    public boolean isBreakpointActive(@NotNull XBreakpoint<?> b) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return !this.areBreakpointsMuted() && b.isEnabled() && !this.isInactiveSlaveBreakpoint(b) && !((XBreakpointBase)b).isDisposed();
    }

    public boolean areBreakpointsMuted() {
        return this.mySessionData.isBreakpointsMuted();
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void addSessionListener(@NotNull XDebugSessionListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeSessionListener(@NotNull XDebugSessionListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void setBreakpointMuted(boolean muted) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.areBreakpointsMuted() == muted) {
            return;
        }
        this.mySessionData.setBreakpointsMuted(muted);
        this.processAllBreakpoints(!muted, muted);
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    public void stepOver(boolean ignoreBreakpoints) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.myDebugProcess.startStepOver(this.doResume());
    }

    public void stepInto() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startStepInto(this.doResume());
    }

    public void stepOut() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startStepOut(this.doResume());
    }

    public <V extends XSmartStepIntoVariant> void smartStepInto(XSmartStepIntoHandler<V> handler2, V variant) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        XSuspendContext context = this.doResume();
        handler2.startStepInto(variant, context);
    }

    public void forceStepInto() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startForceStepInto(this.doResume());
    }

    public void runToPosition(@NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        if (ignoreBreakpoints) {
            this.disableBreakpoints();
        }
        this.myDebugProcess.runToPosition(position, this.doResume());
    }

    public void pause() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.startPausing();
    }

    private void processAllBreakpoints(boolean register, boolean temporary) {
        for (XBreakpointHandler handler2 : this.myDebugProcess.getBreakpointHandlers()) {
            this.processBreakpoints(handler2, register, temporary);
        }
    }

    private void disableBreakpoints() {
        this.myBreakpointsDisabled = true;
        this.processAllBreakpoints(false, true);
    }

    public void resume() {
        if (!this.myDebugProcess.checkCanPerformCommands()) {
            return;
        }
        this.myDebugProcess.resume(this.doResume());
    }

    @Nullable
    private XSuspendContext doResume() {
        if (!this.myPaused.getAndSet(false)) {
            return null;
        }
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).beforeSessionResume();
        XSuspendContext context = this.mySuspendContext;
        this.clearPausedData();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.mySessionTab != null) {
                this.mySessionTab.getUi().clearAttractionBy("breakpoint");
            }
        });
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionResumed();
        return context;
    }

    private void clearPausedData() {
        this.mySuspendContext = null;
        this.myCurrentExecutionStack = null;
        this.myCurrentStackFrame = null;
        this.myTopFramePosition = null;
        this.clearActiveNonLineBreakpoint(false);
        this.updateExecutionPosition();
    }

    public void updateExecutionPosition() {
        if (this.myDebuggerManager.getCurrentSession() == this) {
            boolean isTopFrame = this.isTopFrameSelected();
            this.myDebuggerManager.updateExecutionPoint(this.getCurrentPosition(), !isTopFrame, this.getPositionIconRenderer(isTopFrame));
            if (Registry.is((String)"debugger.show.values.between.lines")) {
                XDebuggerInlayUtil.setupValuePlaceholders(this, false);
            }
        }
    }

    public boolean isTopFrameSelected() {
        return this.myCurrentExecutionStack != null && this.myIsTopFrame;
    }

    public void showExecutionPoint() {
        XStackFrame topFrame;
        XExecutionStack executionStack;
        if (this.mySuspendContext != null && (executionStack = this.mySuspendContext.getActiveExecutionStack()) != null && (topFrame = executionStack.getTopFrame()) != null) {
            this.setCurrentStackFrame(executionStack, topFrame, true);
            this.myDebuggerManager.showExecutionPosition();
        }
    }

    public void setCurrentStackFrame(@NotNull XExecutionStack executionStack, @NotNull XStackFrame frame, boolean isTopFrame) {
        if (this.mySuspendContext == null) {
            return;
        }
        boolean frameChanged = this.myCurrentStackFrame != frame;
        this.myCurrentExecutionStack = executionStack;
        this.myCurrentStackFrame = frame;
        this.myIsTopFrame = isTopFrame;
        if (frameChanged) {
            ((XDebugSessionListener)this.myDispatcher.getMulticaster()).stackFrameChanged();
        }
        this.activateSession();
    }

    void activateSession() {
        this.myDebuggerManager.setCurrentSession(this);
        this.updateExecutionPosition();
    }

    public XBreakpoint<?> getActiveNonLineBreakpoint() {
        if (this.myActiveNonLineBreakpoint != null) {
            XSourcePosition breakpointPosition = this.myActiveNonLineBreakpoint.getSourcePosition();
            XSourcePosition position = this.getTopFramePosition();
            if (breakpointPosition == null || position != null && (!breakpointPosition.getFile().equals(position.getFile()) || breakpointPosition.getLine() != position.getLine())) {
                return this.myActiveNonLineBreakpoint;
            }
        }
        return null;
    }

    @Nullable
    private GutterIconRenderer getPositionIconRenderer(boolean isTopFrame) {
        if (!isTopFrame) {
            return null;
        }
        XBreakpoint<?> activeNonLineBreakpoint = this.getActiveNonLineBreakpoint();
        if (activeNonLineBreakpoint != null) {
            return ((XBreakpointBase)activeNonLineBreakpoint).createGutterIconRenderer();
        }
        if (this.myCurrentExecutionStack != null) {
            return this.myCurrentExecutionStack.getExecutionLineIconRenderer();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon, @Nullable String errorMessage) {
        Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
        synchronized (map2) {
            CustomizedBreakpointPresentation presentation = this.myRegisteredBreakpoints.get(breakpoint);
            if (presentation == null || Comparing.equal((Object)presentation.getIcon(), (Object)icon) && Comparing.strEqual((String)presentation.getErrorMessage(), (String)errorMessage)) {
                return;
            }
            presentation.setErrorMessage(errorMessage);
            presentation.setIcon(icon);
            long timestamp = presentation.getTimestamp();
            if (timestamp != 0L && XDebuggerUtilImpl.getVerifiedIcon(breakpoint).equals(icon)) {
                long delay = System.currentTimeMillis() - timestamp;
                presentation.setTimestamp(0L);
                BreakpointsUsageCollector.reportUsage(breakpoint, "verified." + (int)Math.pow(10.0, (int)Math.log10(delay)) + "+");
            }
        }
        this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate((XLineBreakpointImpl)breakpoint);
    }

    public void setBreakpointVerified(@NotNull XLineBreakpoint<?> breakpoint) {
        this.updateBreakpointPresentation(breakpoint, XDebuggerUtilImpl.getVerifiedIcon(breakpoint), null);
    }

    public void setBreakpointInvalid(@NotNull XLineBreakpoint<?> breakpoint, @Nullable String errorMessage) {
        this.updateBreakpointPresentation(breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        return this.breakpointReached(breakpoint, null, suspendContext);
    }

    public boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext) {
        return this.breakpointReached(breakpoint, evaluatedLogExpression, suspendContext, true);
    }

    public void breakpointReachedNoProcessing(@NotNull XBreakpoint<?> breakpoint, @NotNull XSuspendContext suspendContext) {
        this.breakpointReached(breakpoint, null, suspendContext, false);
    }

    private boolean breakpointReached(@NotNull XBreakpoint<?> breakpoint, @Nullable String evaluatedLogExpression, @NotNull XSuspendContext suspendContext, boolean doProcessing) {
        if (doProcessing) {
            if (breakpoint.isLogMessage()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                OpenFileHyperlinkInfo hyperlinkInfo = position != null ? new OpenFileHyperlinkInfo(this.myProject, position.getFile(), position.getLine()) : null;
                this.printMessage(XDebuggerBundle.message((String)"xbreakpoint.reached.text", (Object[])new Object[0]) + " ", XBreakpointUtil.getShortText(breakpoint), (HyperlinkInfo)hyperlinkInfo);
            }
            if (breakpoint.isLogStack()) {
                this.myDebugProcess.logStack(suspendContext, (XDebugSession)this);
            }
            if (evaluatedLogExpression != null) {
                this.printMessage(evaluatedLogExpression, null, null);
            }
            this.processDependencies(breakpoint);
            if (breakpoint.getSuspendPolicy() == SuspendPolicy.NONE) {
                return false;
            }
        }
        this.myActiveNonLineBreakpoint = !(breakpoint instanceof XLineBreakpoint) || ((XLineBreakpoint)breakpoint).getType().canBeHitInOtherPlaces() ? breakpoint : null;
        this.myDebuggerManager.setCurrentSession(this);
        this.positionReachedInternal(suspendContext, true);
        if (doProcessing && breakpoint instanceof XLineBreakpoint && ((XLineBreakpoint)breakpoint).isTemporary()) {
            this.handleTemporaryBreakpointHit(breakpoint);
        }
        return true;
    }

    private void handleTemporaryBreakpointHit(final XBreakpoint<?> breakpoint) {
        this.addSessionListener(new XDebugSessionListener(){

            private void removeBreakpoint() {
                XDebuggerUtil.getInstance().removeBreakpoint(XDebugSessionImpl.this.myProject, breakpoint);
                XDebugSessionImpl.this.removeSessionListener(this);
            }

            public void sessionResumed() {
                this.removeBreakpoint();
            }

            public void sessionStopped() {
                this.removeBreakpoint();
            }
        });
    }

    public void processDependencies(XBreakpoint<?> breakpoint) {
        boolean added;
        XDependentBreakpointManager dependentBreakpointManager = this.myDebuggerManager.getBreakpointManager().getDependentBreakpointManager();
        if (!dependentBreakpointManager.isMasterOrSlave(breakpoint)) {
            return;
        }
        List<XBreakpoint<?>> breakpoints = dependentBreakpointManager.getSlaveBreakpoints(breakpoint);
        this.myInactiveSlaveBreakpoints.removeAll(breakpoints);
        for (XBreakpoint<?> slaveBreakpoint : breakpoints) {
            this.processAllHandlers(slaveBreakpoint, true);
        }
        if (dependentBreakpointManager.getMasterBreakpoint(breakpoint) != null && !dependentBreakpointManager.isLeaveEnabled(breakpoint) && (added = this.myInactiveSlaveBreakpoints.add(breakpoint))) {
            this.processAllHandlers(breakpoint, false);
            this.myDebuggerManager.getBreakpointManager().getLineBreakpointManager().queueBreakpointUpdate(breakpoint);
        }
    }

    private void printMessage(String message, String hyperLinkText, @Nullable HyperlinkInfo info) {
        AppUIUtil.invokeOnEdt(() -> {
            this.myConsoleView.print(message, ConsoleViewContentType.SYSTEM_OUTPUT);
            if (info != null) {
                this.myConsoleView.printHyperlink(hyperLinkText, info);
            } else if (hyperLinkText != null) {
                this.myConsoleView.print(hyperLinkText, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            this.myConsoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        });
    }

    public void unsetPaused() {
        this.myPaused.set(false);
    }

    private void positionReachedInternal(@NotNull XSuspendContext suspendContext, boolean attract) {
        this.enableBreakpoints();
        this.mySuspendContext = suspendContext;
        this.myCurrentExecutionStack = suspendContext.getActiveExecutionStack();
        this.myCurrentStackFrame = this.myCurrentExecutionStack != null ? this.myCurrentExecutionStack.getTopFrame() : null;
        this.myIsTopFrame = true;
        this.myTopFramePosition = this.myCurrentStackFrame != null ? this.myCurrentStackFrame.getSourcePosition() : null;
        this.myPaused.set(true);
        this.updateExecutionPosition();
        boolean showOnSuspend = this.myShowTabOnSuspend.compareAndSet(true, false);
        if (showOnSuspend || attract) {
            AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
                if (showOnSuspend) {
                    this.initSessionTab(null);
                    this.showSessionTab();
                }
                if (attract) {
                    if (this.mySessionTab == null) {
                        LOG.debug("Cannot request focus because Session Tab is not initialized yet");
                        return;
                    }
                    if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isShowDebuggerOnBreakpoint()) {
                        this.mySessionTab.toFront(true, this::updateExecutionPosition);
                    }
                    if (this.myTopFramePosition == null) {
                        XDebugSessionTab.showFramesView(this);
                    }
                    this.mySessionTab.getUi().attractBy("breakpoint");
                }
            });
        }
        ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionPaused();
    }

    public void positionReached(@NotNull XSuspendContext suspendContext) {
        this.positionReached(suspendContext, false);
    }

    public void positionReached(@NotNull XSuspendContext suspendContext, boolean attract) {
        this.clearActiveNonLineBreakpoint(false);
        this.positionReachedInternal(suspendContext, attract);
    }

    public void sessionResumed() {
        this.doResume();
    }

    private void enableBreakpoints() {
        if (this.myBreakpointsDisabled) {
            this.myBreakpointsDisabled = false;
            ReadAction.run(() -> this.processAllBreakpoints(true, false));
        }
    }

    public boolean isStopped() {
        return this.myStopped.get();
    }

    private void stopImpl() {
        if (!this.myStopped.compareAndSet(false, true)) {
            return;
        }
        try {
            this.removeBreakpointListeners();
        }
        finally {
            this.myDebugProcess.stopAsync().onSuccess(aVoid -> {
                if (!this.myProject.isDisposed()) {
                    ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(XDebuggerManager.TOPIC)).processStopped(this.myDebugProcess);
                }
                if (this.mySessionTab != null) {
                    AppUIUtil.invokeOnEdt(() -> {
                        ((XWatchesViewImpl)this.mySessionTab.getWatchesView()).updateSessionData();
                        this.mySessionTab.detachFromSession();
                    });
                } else if (this.myConsoleView != null) {
                    AppUIUtil.invokeOnEdt(() -> Disposer.dispose((Disposable)this.myConsoleView));
                }
                this.clearPausedData();
                if (Registry.is((String)"debugger.show.values.between.lines")) {
                    XDebuggerInlayUtil.setupValuePlaceholders(this, true);
                }
                if (this.myValueMarkers != null) {
                    this.myValueMarkers.clear();
                }
                if (XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isUnmuteOnStop()) {
                    this.mySessionData.setBreakpointsMuted(false);
                }
                this.myDebuggerManager.removeSession(this);
                ((XDebugSessionListener)this.myDispatcher.getMulticaster()).sessionStopped();
                this.myDispatcher.getListeners().clear();
                this.myProject.putUserData(XDebuggerEditorLinePainter.CACHE, null);
                Map<XBreakpoint<?>, CustomizedBreakpointPresentation> map2 = this.myRegisteredBreakpoints;
                synchronized (map2) {
                    this.myRegisteredBreakpoints.clear();
                }
            });
        }
    }

    private void removeBreakpointListeners() {
        Disposable breakpointListenerDisposable = this.myBreakpointListenerDisposable;
        if (breakpointListenerDisposable != null) {
            this.myBreakpointListenerDisposable = null;
            Disposer.dispose((Disposable)breakpointListenerDisposable);
        }
    }

    public boolean isInactiveSlaveBreakpoint(XBreakpoint<?> breakpoint) {
        return this.myInactiveSlaveBreakpoints.contains(breakpoint);
    }

    public void stop() {
        ProcessHandler processHandler2;
        ProcessHandler processHandler3 = processHandler2 = this.myDebugProcess == null ? null : this.myDebugProcess.getProcessHandler();
        if (processHandler2 == null || processHandler2.isProcessTerminated() || processHandler2.isProcessTerminating()) {
            return;
        }
        if (processHandler2.detachIsDefault()) {
            processHandler2.detachProcess();
        } else {
            processHandler2.destroyProcess();
        }
    }

    public void reportError(@NotNull String message) {
        this.reportMessage(message, MessageType.ERROR);
    }

    public void reportMessage(@NotNull String message, @NotNull MessageType type) {
        this.reportMessage(message, type, null);
    }

    public void reportMessage(@NotNull String message, @NotNull MessageType type, @Nullable HyperlinkListener listener2) {
        NotificationListener notificationListener = listener2 == null ? null : (notification, event) -> {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                listener2.hyperlinkUpdate(event);
            }
        };
        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("", message, type.toNotificationType(), notificationListener).notify(this.myProject);
    }

    public void clearActiveNonLineBreakpoint(boolean updateExecutionPointIcon) {
        this.myActiveNonLineBreakpoint = null;
        if (updateExecutionPointIcon) {
            this.myDebuggerManager.updateExecutionPoint(this.getPositionIconRenderer(this.isTopFrameSelected()));
        }
    }

    @NotNull
    private String getConfigurationName() {
        RunProfile profile2;
        if (this.myEnvironment != null && (profile2 = this.myEnvironment.getRunProfile()) instanceof RunConfiguration) {
            return ((RunConfiguration)profile2).getType().getId();
        }
        return this.getSessionName();
    }

    public void setWatchExpressions(@NotNull List<XExpression> watchExpressions) {
        this.mySessionData.setWatchExpressions(watchExpressions);
        this.myDebuggerManager.getWatchesManager().setWatches(this.getConfigurationName(), watchExpressions);
    }

    List<XExpression> getWatchExpressions() {
        return this.myDebuggerManager.getWatchesManager().getWatches(this.getConfigurationName());
    }

    @Nullable
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.myEnvironment;
    }

    private class MyDependentBreakpointListener
    implements XDependentBreakpointListener {
        private MyDependentBreakpointListener() {
        }

        @Override
        public void dependencySet(@NotNull XBreakpoint<?> slave, @NotNull XBreakpoint<?> master) {
            boolean added = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.add(slave);
            if (added) {
                XDebugSessionImpl.this.processAllHandlers(slave, false);
            }
        }

        @Override
        public void dependencyCleared(XBreakpoint<?> breakpoint) {
            boolean removed = XDebugSessionImpl.this.myInactiveSlaveBreakpoints.remove(breakpoint);
            if (removed) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
            }
        }
    }

    private final class MyBreakpointListener
    implements XBreakpointListener<XBreakpoint<?>> {
        private MyBreakpointListener() {
        }

        public void breakpointAdded(@NotNull XBreakpoint<?> breakpoint) {
            CustomizedBreakpointPresentation presentation;
            if (this.processAdd(breakpoint) && (presentation = XDebugSessionImpl.this.getBreakpointPresentation(breakpoint)) != null) {
                if (XDebuggerUtilImpl.getVerifiedIcon(breakpoint).equals(presentation.getIcon())) {
                    BreakpointsUsageCollector.reportUsage(breakpoint, "verified.0");
                } else {
                    presentation.setTimestamp(System.currentTimeMillis());
                }
            }
        }

        public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
            if (XDebugSessionImpl.this.getActiveNonLineBreakpoint() == breakpoint) {
                XDebugSessionImpl.this.clearActiveNonLineBreakpoint(true);
            }
            this.processRemove(breakpoint);
        }

        void processRemove(@NotNull XBreakpoint<?> breakpoint) {
            XDebugSessionImpl.this.processAllHandlers(breakpoint, false);
        }

        boolean processAdd(@NotNull XBreakpoint<?> breakpoint) {
            if (!XDebugSessionImpl.this.myBreakpointsDisabled) {
                XDebugSessionImpl.this.processAllHandlers(breakpoint, true);
                return true;
            }
            return false;
        }

        public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
            this.processRemove(breakpoint);
            this.processAdd(breakpoint);
        }
    }
}

