/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="debuggerHistoryManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerHistoryManager
implements PersistentStateComponent<Element> {
    public static final int MAX_RECENT_EXPRESSIONS = 10;
    private static final SerializationFilter SERIALIZATION_FILTER = new SkipDefaultsSerializationFilter();
    private static final String STATE_TAG = "root";
    private static final String ID_ATTRIBUTE = "id";
    private static final String EXPRESSIONS_TAG = "expressions";
    private static final String EXPRESSION_TAG = "expression";
    private final Map<String, LinkedList<XExpression>> myRecentExpressions = new HashMap<String, LinkedList<XExpression>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project) {
        return (XDebuggerHistoryManager)ServiceManager.getService((Project)project, XDebuggerHistoryManager.class);
    }

    public boolean addRecentExpression(@NotNull @NonNls String id, @Nullable XExpression expression) {
        if (XDebuggerUtilImpl.isEmptyExpression(expression) || expression.getExpression().length() > 100000) {
            return false;
        }
        LinkedList list2 = this.myRecentExpressions.computeIfAbsent(id, k -> new LinkedList());
        if (list2.size() == 10) {
            list2.removeLast();
        }
        XExpressionImpl trimmedExpression = new XExpressionImpl(expression.getExpression().trim(), expression.getLanguage(), expression.getCustomInfo(), expression.getMode());
        list2.remove(trimmedExpression);
        list2.addFirst(trimmedExpression);
        return true;
    }

    public List<XExpression> getRecentExpressions(@NonNls String id) {
        return ContainerUtil.notNullize((List)this.myRecentExpressions.get(id));
    }

    @Nullable
    public Element getState() {
        Element state = new Element(STATE_TAG);
        for (String id : this.myRecentExpressions.keySet()) {
            LinkedList<XExpression> expressions = this.myRecentExpressions.get(id);
            List states = ContainerUtil.map(expressions, ExpressionState::new);
            Element entryElement = new Element(EXPRESSIONS_TAG);
            entryElement.setAttribute(ID_ATTRIBUTE, id);
            for (ExpressionState expressionState : states) {
                entryElement.addContent(XmlSerializer.serialize((Object)expressionState, (SerializationFilter)SERIALIZATION_FILTER));
            }
            state.addContent(entryElement);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.myRecentExpressions.clear();
        for (Element expression : state.getChildren(EXPRESSIONS_TAG)) {
            String id = expression.getAttributeValue(ID_ATTRIBUTE);
            LinkedList<XExpression> expressions = new LinkedList<XExpression>();
            for (Element expressionElement : expression.getChildren(EXPRESSION_TAG)) {
                expressions.add(((ExpressionState)XmlSerializer.deserialize((Element)expressionElement, ExpressionState.class)).toXExpression());
            }
            this.myRecentExpressions.put(id, expressions);
        }
    }

    @Tag(value="expression")
    private static class ExpressionState {
        @Tag(value="expression-string")
        String myExpression;
        @Tag(value="language-id")
        String myLanguageId;
        @Tag(value="custom-info")
        String myCustomInfo;
        @Tag(value="evaluation-mode")
        EvaluationMode myEvaluationMode;

        ExpressionState() {
        }

        ExpressionState(@NotNull XExpression expression) {
            this.myExpression = expression.getExpression();
            Language language = expression.getLanguage();
            this.myLanguageId = language == null ? null : language.getID();
            this.myCustomInfo = expression.getCustomInfo();
            this.myEvaluationMode = expression.getMode();
        }

        @NotNull
        XExpression toXExpression() {
            if (this.myEvaluationMode == null) {
                this.myEvaluationMode = EvaluationMode.EXPRESSION;
            }
            return new XExpressionImpl(this.myExpression, Language.findLanguageByID((String)this.myLanguageId), this.myCustomInfo, this.myEvaluationMode);
        }
    }
}

