/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.CommonBundle;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroupingRule;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XDebuggerUtilImpl
extends XDebuggerUtil {
    private XLineBreakpointType<?>[] myLineBreakpointTypes;
    private Map<Class<? extends XBreakpointType>, XBreakpointType> myBreakpointTypeByClass;

    public XLineBreakpointType<?>[] getLineBreakpointTypes() {
        if (this.myLineBreakpointTypes == null) {
            this.myLineBreakpointTypes = (XLineBreakpointType[])XBreakpointUtil.breakpointTypes().select(XLineBreakpointType.class).toArray(XLineBreakpointType[]::new);
        }
        return this.myLineBreakpointTypes;
    }

    public void toggleLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file2, int line, boolean temporary) {
        this.toggleAndReturnLineBreakpoint(project, file2, line, temporary);
    }

    @Nullable
    private XLineBreakpointType<?> getBreakpointTypeByPosition(@NotNull Project project, @NotNull VirtualFile file2, int line) {
        XLineBreakpointType<?> typeWinner = null;
        for (XLineBreakpointType<?> type : this.getLineBreakpointTypes()) {
            if (!type.canPutAt(file2, line, project) || typeWinner != null && type.getPriority() <= typeWinner.getPriority()) continue;
            typeWinner = type;
        }
        return typeWinner;
    }

    @NotNull
    public Promise<XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull VirtualFile file2, int line, boolean temporary) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XLineBreakpointType<?> typeWinner = this.getBreakpointTypeByPosition(project, file2, line);
        if (typeWinner != null) {
            return this.toggleAndReturnLineBreakpoint(project, typeWinner, file2, line, temporary);
        }
        return Promises.rejectedPromise((Throwable)new RuntimeException("Cannot find appropriate breakpoint type"));
    }

    public boolean canPutBreakpointAt(@NotNull Project project, @NotNull VirtualFile file2, int line) {
        return Arrays.stream(this.getLineBreakpointTypes()).anyMatch(type -> type.canPutAt(file2, line, project));
    }

    public <P extends XBreakpointProperties> void toggleLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line, boolean temporary) {
        this.toggleAndReturnLineBreakpoint(project, type, file2, line, temporary);
    }

    @NotNull
    public <P extends XBreakpointProperties> Promise<XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line, boolean temporary) {
        XSourcePositionImpl position = XSourcePositionImpl.create(file2, line);
        return XDebuggerUtilImpl.toggleAndReturnLineBreakpoint(project, Collections.singletonList(type), position, temporary, null, true);
    }

    public static Promise<List<? extends XLineBreakpointType.XLineBreakpointVariant>> getLineBreakpointVariants(@NotNull Project project, @NotNull List<? extends XLineBreakpointType> types, @NotNull XSourcePosition position) {
        SmartList promises = new SmartList();
        for (XLineBreakpointType xLineBreakpointType : types) {
            promises.add(xLineBreakpointType.computeVariantsAsync(project, position).then(o -> {
                if (((List)o).isEmpty() && types.size() > 1) {
                    XLineBreakpointType xLineBreakpointType = type;
                    xLineBreakpointType.getClass();
                    return Collections.singletonList(new XLineBreakpointType.XLineBreakpointAllVariant(xLineBreakpointType, position){
                        {
                            XLineBreakpointType xLineBreakpointType2 = x0;
                            xLineBreakpointType2.getClass();
                            super(xLineBreakpointType2, x1);
                        }

                        @NotNull
                        public String getText() {
                            return StringUtil.notNullize((String)StringUtil.unpluralize((String)type.getTitle()), (String)type.getTitle());
                        }

                        @Nullable
                        public Icon getIcon() {
                            return type.getEnabledIcon();
                        }
                    });
                }
                return o;
            }));
        }
        return Promises.collectResults((Collection)promises).then(v -> StreamEx.of((Collection)v).toFlatList(l -> l));
    }

    @NotNull
    public static Promise<XLineBreakpoint> toggleAndReturnLineBreakpoint(@NotNull Project project, @NotNull List<? extends XLineBreakpointType> types, @NotNull XSourcePosition position, final boolean temporary, final @Nullable Editor editor, boolean canRemove) {
        VirtualFile file2 = position.getFile();
        int line = position.getLine();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        for (XLineBreakpointType xLineBreakpointType : types) {
            XLineBreakpoint breakpoint = breakpointManager.findBreakpointAtLine(xLineBreakpointType, file2, line);
            if (breakpoint == null) continue;
            if (!temporary && canRemove) {
                XDebuggerUtilImpl.removeBreakpointWithConfirmation(project, breakpoint);
            }
            return Promises.resolvedPromise();
        }
        return XDebuggerUtilImpl.getLineBreakpointVariants(project, types, position).thenAsync(variants -> {
            final AsyncPromise res2 = new AsyncPromise();
            GuiUtils.invokeLaterIfNeeded(() -> {
                for (XLineBreakpointType type : types) {
                    if (breakpointManager.findBreakpointAtLine(type, file2, line) == null) continue;
                    return;
                }
                if (!variants.isEmpty() && editor != null) {
                    RelativePoint relativePoint = DebuggerUIUtil.getPositionForPopup(editor, line);
                    if (variants.size() > 1 && relativePoint != null) {
                        int caretOffset = editor.getCaretModel().getOffset();
                        XLineBreakpointType.XLineBreakpointVariant defaultVariant = null;
                        for (XLineBreakpointType.XLineBreakpointVariant variant : variants) {
                            TextRange range2 = variant.getHighlightRange();
                            if (range2 == null || !range2.contains(caretOffset) || defaultVariant != null && defaultVariant.getHighlightRange().getLength() <= range2.getLength()) continue;
                            defaultVariant = variant;
                        }
                        final int defaultIndex = defaultVariant != null ? variants.indexOf(defaultVariant) : 0;
                        class MySelectionListener
                        implements ListSelectionListener {
                            RangeHighlighter myHighlighter = null;

                            MySelectionListener() {
                            }

                            @Override
                            public void valueChanged(ListSelectionEvent e) {
                                if (!e.getValueIsAdjusting()) {
                                    this.updateHighlighter(((JList)e.getSource()).getSelectedValue());
                                }
                            }

                            public void initialSet(Object value) {
                                if (this.myHighlighter == null) {
                                    this.updateHighlighter(value);
                                }
                            }

                            void updateHighlighter(Object value) {
                                this.clearHighlighter();
                                if (value instanceof XLineBreakpointType.XLineBreakpointVariant) {
                                    TextRange range2 = ((XLineBreakpointType.XLineBreakpointVariant)value).getHighlightRange();
                                    TextRange lineRange = DocumentUtil.getLineTextRange(editor.getDocument(), line);
                                    if (range2 == null) {
                                        range2 = lineRange;
                                    }
                                    if (!range2.isEmpty() && range2.intersects(lineRange)) {
                                        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
                                        TextAttributes attributes = scheme2.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
                                        this.myHighlighter = editor.getMarkupModel().addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 3001, attributes, HighlighterTargetArea.EXACT_RANGE);
                                    }
                                }
                            }

                            private void clearHighlighter() {
                                if (this.myHighlighter != null) {
                                    this.myHighlighter.dispose();
                                }
                            }
                        }
                        final MySelectionListener selectionListener = new MySelectionListener();
                        ListPopupImpl popup2 = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<XLineBreakpointType.XLineBreakpointVariant>("Set Breakpoint", variants){
                            {
                                super(x0, x1);
                            }

                            @NotNull
                            public String getTextFor(XLineBreakpointType.XLineBreakpointVariant value) {
                                return value.getText();
                            }

                            public Icon getIconFor(XLineBreakpointType.XLineBreakpointVariant value) {
                                return value.getIcon();
                            }

                            public void canceled() {
                                selectionListener.clearHighlighter();
                                res2.cancel();
                            }

                            public PopupStep onChosen(XLineBreakpointType.XLineBreakpointVariant selectedValue, boolean finalChoice) {
                                selectionListener.clearHighlighter();
                                XDebuggerUtilImpl.insertBreakpoint(selectedValue.createProperties(), (AsyncPromise<? super XLineBreakpoint>)res2, breakpointManager, file2, line, selectedValue.getType(), temporary);
                                return FINAL_CHOICE;
                            }

                            public int getDefaultOptionIndex() {
                                return defaultIndex;
                            }
                        }){
                            {
                                super(x0);
                            }

                            @Override
                            protected void afterShow() {
                                super.afterShow();
                                selectionListener.initialSet(this.getList().getSelectedValue());
                            }
                        };
                        DebuggerUIUtil.registerExtraHandleShortcuts(popup2, "ToggleLineBreakpoint");
                        popup2.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText("ToggleLineBreakpoint"));
                        popup2.addListSelectionListener(selectionListener);
                        popup2.show(relativePoint);
                        return;
                    }
                    XLineBreakpointType.XLineBreakpointVariant variant = (XLineBreakpointType.XLineBreakpointVariant)variants.get(0);
                    XDebuggerUtilImpl.insertBreakpoint(variant.createProperties(), (AsyncPromise<? super XLineBreakpoint>)res2, breakpointManager, file2, line, variant.getType(), temporary);
                    return;
                }
                XLineBreakpointType type = (XLineBreakpointType)types.get(0);
                XDebuggerUtilImpl.insertBreakpoint(type.createBreakpointProperties(file2, line), (AsyncPromise<? super XLineBreakpoint>)res2, breakpointManager, file2, line, type, temporary);
            }, (ModalityState)ModalityState.defaultModalityState());
            return res2;
        });
    }

    private static <P extends XBreakpointProperties> void insertBreakpoint(P properties, AsyncPromise<? super XLineBreakpoint> res2, XBreakpointManager breakpointManager, VirtualFile file2, int line, XLineBreakpointType<P> type, Boolean temporary) {
        res2.setResult(WriteAction.compute(() -> breakpointManager.addLineBreakpoint(type, file2.getUrl(), line, properties, temporary.booleanValue())));
    }

    public static void removeBreakpointWithConfirmation(Project project, XBreakpoint<?> breakpoint) {
        if (!(XDebuggerUtilImpl.isEmptyExpression(breakpoint.getConditionExpression()) && XDebuggerUtilImpl.isEmptyExpression(breakpoint.getLogExpressionObject()) || ApplicationManager.getApplication().isHeadlessEnvironment() || ApplicationManager.getApplication().isUnitTestMode() || !XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isConfirmBreakpointRemoval())) {
            StringBuilder message = new StringBuilder(XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.message", (Object[])new Object[0]));
            if (!XDebuggerUtilImpl.isEmptyExpression(breakpoint.getConditionExpression())) {
                message.append(XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.message.condition", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)breakpoint.getConditionExpression().getExpression())}));
            }
            if (!XDebuggerUtilImpl.isEmptyExpression(breakpoint.getLogExpressionObject())) {
                message.append(XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.message.log", (Object[])new Object[]{StringUtil.escapeXmlEntities((String)breakpoint.getLogExpressionObject().getExpression())}));
            }
            if (Messages.showOkCancelDialog((String)message.toString(), (String)XDebuggerBundle.message((String)"message.confirm.breakpoint.removal.title", (Object[])new Object[0]), (String)CommonBundle.message((String)"button.remove", (Object[])new Object[0]), (String)Messages.CANCEL_BUTTON, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    if (isSelected) {
                        XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().setConfirmBreakpointRemoval(false);
                    }
                }
            }) != 0) {
                return;
            }
        }
        ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)project).getBreakpointManager()).rememberRemovedBreakpoint((XBreakpointBase)breakpoint);
        XDebuggerUtilImpl.getInstance().removeBreakpoint(project, breakpoint);
    }

    public void removeBreakpoint(Project project, XBreakpoint<?> breakpoint) {
        WriteAction.run(() -> XDebuggerManager.getInstance((Project)project).getBreakpointManager().removeBreakpoint(breakpoint));
    }

    public <T extends XBreakpointType> T findBreakpointType(@NotNull Class<T> typeClass) {
        if (this.myBreakpointTypeByClass == null) {
            this.myBreakpointTypeByClass = XBreakpointUtil.breakpointTypes().toMap(Object::getClass, t -> t);
        }
        XBreakpointType type = this.myBreakpointTypeByClass.get(typeClass);
        return (T)type;
    }

    public <T extends XDebuggerSettings<?>> T getDebuggerSettings(Class<T> aClass) {
        return XDebuggerSettingManagerImpl.getInstanceImpl().getSettings(aClass);
    }

    public XValueContainer getValueContainer(DataContext dataContext) {
        return XDebuggerTreeActionBase.getSelectedValue(dataContext);
    }

    @Nullable
    public XSourcePosition createPosition(@Nullable VirtualFile file2, int line) {
        return file2 == null ? null : XSourcePositionImpl.create(file2, line);
    }

    @Nullable
    public XSourcePosition createPosition(@Nullable VirtualFile file2, int line, int column) {
        return file2 == null ? null : XSourcePositionImpl.create(file2, line, column);
    }

    @Nullable
    public XSourcePosition createPositionByOffset(VirtualFile file2, int offset) {
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @Nullable
    public XSourcePosition createPositionByElement(PsiElement element) {
        return XSourcePositionImpl.createByElement(element);
    }

    public <B extends XLineBreakpoint<?>> XBreakpointGroupingRule<B, ?> getGroupingByFileRule() {
        return new XBreakpointFileGroupingRule();
    }

    @Nullable
    public static XSourcePosition getCaretPosition(@NotNull Project project, DataContext context) {
        Editor editor = XDebuggerUtilImpl.getEditor(project, context);
        if (editor == null) {
            return null;
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return XSourcePositionImpl.createByOffset(file2, offset);
    }

    @NotNull
    public static Collection<XSourcePosition> getAllCaretsPositions(@NotNull Project project, DataContext context) {
        Editor editor = XDebuggerUtilImpl.getEditor(project, context);
        if (editor == null) {
            return Collections.emptyList();
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
        SmartList res2 = new SmartList();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            XSourcePositionImpl position = XSourcePositionImpl.createByOffset(file2, caret.getOffset());
            if (position == null) continue;
            res2.add(position);
        }
        return res2;
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project, DataContext context) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor == null) {
            return FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        }
        return editor;
    }

    public <B extends XBreakpoint<?>> Comparator<B> getDefaultBreakpointComparator(XBreakpointType<B, ?> type) {
        return Comparator.comparing(arg_0 -> type.getDisplayText(arg_0));
    }

    public <P extends XBreakpointProperties> Comparator<XLineBreakpoint<P>> getDefaultLineBreakpointComparator() {
        return (o1, o2) -> {
            int fileCompare = o1.getFileUrl().compareTo(o2.getFileUrl());
            if (fileCompare != 0) {
                return fileCompare;
            }
            return o1.getLine() - o2.getLine();
        };
    }

    @Nullable
    public static XDebuggerEvaluator getEvaluator(XSuspendContext suspendContext) {
        XStackFrame stackFrame;
        XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
        if (executionStack != null && (stackFrame = executionStack.getTopFrame()) != null) {
            return stackFrame.getEvaluator();
        }
        return null;
    }

    public void iterateLine(@NotNull Project project, @NotNull Document document, int line, @NotNull Processor<PsiElement> processor2) {
        int lineEnd;
        int lineStart;
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return;
        }
        try {
            lineStart = document.getLineStartOffset(line);
            lineEnd = document.getLineEndOffset(line);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        int offset = lineStart;
        while (offset < lineEnd) {
            PsiElement element = file2.findElementAt(offset);
            if (element != null && element.getTextLength() > 0) {
                if (!processor2.process((Object)element)) {
                    return;
                }
                offset = element.getTextRange().getEndOffset();
                continue;
            }
            ++offset;
        }
    }

    public <B extends XLineBreakpoint<?>> List<XBreakpointGroupingRule<B, ?>> getGroupingByFileRuleAsList() {
        return Collections.singletonList(this.getGroupingByFileRule());
    }

    @Nullable
    public PsiElement findContextElement(@NotNull VirtualFile virtualFile, int offset, @NotNull Project project, boolean checkXml) {
        PsiLanguageInjectionHost parent;
        PsiElement element;
        PsiFile file2;
        if (!virtualFile.isValid()) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        PsiFile psiFile = file2 = document == null ? null : PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (file2 == null) {
            return null;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > document.getTextLength()) {
            offset = document.getTextLength();
        }
        int startOffset = offset;
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
        PsiElement result2 = null;
        do {
            if ((element = file2.findElementAt(offset)) instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            result2 = element;
            break;
        } while ((offset = element.getTextRange().getEndOffset() + 1) < lineEndOffset);
        if (result2 == null) {
            result2 = file2.findElementAt(startOffset);
        }
        if (checkXml && result2 != null && StdFileTypes.XML.getLanguage().equals(result2.getLanguage()) && (parent = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)result2, PsiLanguageInjectionHost.class)) != null) {
            result2 = InjectedLanguageUtil.findElementInInjected(parent, offset);
        }
        return result2;
    }

    public void disableValueLookup(@NotNull Editor editor) {
        ValueLookupManager.DISABLE_VALUE_LOOKUP.set((UserDataHolder)editor, (Object)Boolean.TRUE);
    }

    @Nullable
    public static Editor createEditor(@NotNull OpenFileDescriptor descriptor) {
        return descriptor.canNavigate() ? FileEditorManager.getInstance((Project)descriptor.getProject()).openTextEditor(descriptor, false) : null;
    }

    public static void rebuildAllSessionsViews(@Nullable Project project) {
        if (project == null) {
            return;
        }
        Arrays.stream(XDebuggerManager.getInstance((Project)project).getDebugSessions()).filter(XDebugSession::isSuspended).forEach(XDebugSession::rebuildViews);
    }

    public static void rebuildTreeAndViews(XDebuggerTree tree) {
        if (tree.isDetached()) {
            tree.rebuildAndRestore(XDebuggerTreeState.saveState(tree));
        }
        XDebuggerUtilImpl.rebuildAllSessionsViews(tree.getProject());
    }

    @NotNull
    public XExpression createExpression(@NotNull String text, Language language, String custom, @NotNull EvaluationMode mode) {
        return new XExpressionImpl(text, language, custom, mode);
    }

    public static boolean isEmptyExpression(@Nullable XExpression expression) {
        return expression == null || StringUtil.isEmptyOrSpaces((String)expression.getExpression());
    }

    public void logStack(@NotNull XSuspendContext suspendContext, final @NotNull XDebugSession session2) {
        XExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
        if (activeExecutionStack != null) {
            activeExecutionStack.computeStackFrames(0, (XExecutionStack.XStackFrameContainer)new XStackFrameContainerEx(){
                final List<XStackFrame> myFrames = new ArrayList<XStackFrame>();

                public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
                    this.myFrames.addAll(stackFrames);
                    if (last) {
                        this.print(null);
                    }
                }

                @Override
                public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect2, boolean last) {
                    this.addStackFrames(stackFrames, last);
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    this.print(errorMessage);
                }

                void print(@Nullable String errorMessage) {
                    ConsoleView view = session2.getConsoleView();
                    Project project = session2.getProject();
                    DebuggerUIUtil.invokeLater(() -> view.print("Stack: ", ConsoleViewContentType.SYSTEM_OUTPUT));
                    this.myFrames.forEach(f -> {
                        SimpleColoredText text = new SimpleColoredText();
                        ReadAction.run(() -> f.customizePresentation((ColoredTextContainer)text));
                        XSourcePosition position = f.getSourcePosition();
                        Navigatable navigatable = position != null ? position.createNavigatable(project) : null;
                        DebuggerUIUtil.invokeLater(() -> {
                            view.print("\n\t", ConsoleViewContentType.SYSTEM_OUTPUT);
                            view.printHyperlink(text.toString(), p -> {
                                if (navigatable != null) {
                                    navigatable.navigate(true);
                                }
                            });
                        });
                    });
                    DebuggerUIUtil.invokeLater(() -> {
                        if (errorMessage != null) {
                            view.print("\n\t" + errorMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
                        }
                        view.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                    });
                }
            });
        }
    }

    public static Icon getVerifiedIcon(@NotNull XBreakpoint breakpoint) {
        return breakpoint.getSuspendPolicy() == SuspendPolicy.NONE ? AllIcons.Debugger.Db_verified_no_suspend_breakpoint : AllIcons.Debugger.Db_verified_breakpoint;
    }
}

