/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.ConfigurationState;
import com.intellij.xdebugger.impl.WatchState;
import com.intellij.xdebugger.impl.WatchesManagerState;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class XDebuggerWatchesManager {
    private final Map<String, List<XExpression>> watches = ContainerUtil.newConcurrentMap();

    @NotNull
    public List<XExpression> getWatches(String confName) {
        return ContainerUtil.notNullize(this.watches.get(confName));
    }

    public void setWatches(@NotNull String configurationName, @NotNull List<XExpression> expressions) {
        if (expressions.isEmpty()) {
            this.watches.remove(configurationName);
        } else {
            this.watches.put(configurationName, expressions);
        }
    }

    @NotNull
    public WatchesManagerState saveState(@NotNull WatchesManagerState state) {
        SmartList expressions = new SmartList();
        for (Map.Entry<String, List<XExpression>> entry : this.watches.entrySet()) {
            expressions.add(new ConfigurationState(entry.getKey(), entry.getValue()));
        }
        state.setExpressions((List<ConfigurationState>)expressions);
        return state;
    }

    public void clearContext() {
        this.watches.clear();
    }

    public void loadState(@NotNull WatchesManagerState state) {
        this.clearContext();
        for (ConfigurationState expressionState : state.getExpressions()) {
            List<WatchState> expressionStates = expressionState.getExpressionStates();
            if (ContainerUtil.isEmpty(expressionStates)) continue;
            this.watches.put(expressionState.getName(), ContainerUtil.mapNotNull(expressionStates, XExpressionState::toXExpression));
        }
    }
}

