/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XSourcePositionImpl
implements XSourcePosition {
    private final VirtualFile myFile;

    private XSourcePositionImpl(@NotNull VirtualFile file2) {
        this.myFile = file2;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public static XSourcePositionImpl createByOffset(final @Nullable VirtualFile file2, final int offset) {
        if (file2 == null) {
            return null;
        }
        return new XSourcePositionImpl(file2){
            private final AtomicNotNullLazyValue<Integer> myLine;
            {
                super(file22);
                this.myLine = new AtomicNotNullLazyValue<Integer>(){

                    @NotNull
                    protected Integer compute() {
                        return (Integer)ReadAction.compute(() -> {
                            Document document = FileDocumentManager.getInstance().getDocument(file2);
                            if (document == null) {
                                return -1;
                            }
                            return DocumentUtil.isValidOffset(offset, document) ? document.getLineNumber(offset) : -1;
                        });
                    }
                };
            }

            public int getLine() {
                return (Integer)this.myLine.getValue();
            }

            public int getOffset() {
                return offset;
            }
        };
    }

    @Nullable
    public static XSourcePositionImpl createByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file2 = psiFile.getVirtualFile();
        if (file2 == null) {
            return null;
        }
        final SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element);
        return new XSourcePositionImpl(file2){
            private final AtomicNotNullLazyValue<XSourcePosition> myDelegate;
            {
                super(file2);
                this.myDelegate = new AtomicNotNullLazyValue<XSourcePosition>(){

                    @NotNull
                    protected XSourcePosition compute() {
                        return (XSourcePosition)ReadAction.compute(() -> {
                            PsiElement elem = pointer.getElement();
                            return XSourcePositionImpl.createByOffset(pointer.getVirtualFile(), elem != null ? elem.getTextOffset() : -1);
                        });
                    }
                };
            }

            public int getLine() {
                return ((XSourcePosition)this.myDelegate.getValue()).getLine();
            }

            public int getOffset() {
                return ((XSourcePosition)this.myDelegate.getValue()).getOffset();
            }

            @Override
            @NotNull
            public Navigatable createNavigatable(@NotNull Project project) {
                if (this.myDelegate.isComputed()) {
                    return ((XSourcePosition)this.myDelegate.getValue()).createNavigatable(project);
                }
                PsiElement elem = pointer.getElement();
                if (elem instanceof Navigatable) {
                    return (Navigatable)elem;
                }
                return NonNavigatable.INSTANCE;
            }
        };
    }

    @Contract(value="null , _ -> null; !null, _ -> !null")
    public static XSourcePositionImpl create(@Nullable VirtualFile file2, int line) {
        return file2 == null ? null : XSourcePositionImpl.create(file2, line, 0);
    }

    @Contract(value="null , _, _ -> null; !null, _, _ -> !null")
    public static XSourcePositionImpl create(final @Nullable VirtualFile file2, final int line, final int column) {
        if (file2 == null) {
            return null;
        }
        return new XSourcePositionImpl(file2){
            private final AtomicNotNullLazyValue<Integer> myOffset;
            {
                super(file22);
                this.myOffset = new AtomicNotNullLazyValue<Integer>(){

                    @NotNull
                    protected Integer compute() {
                        return (Integer)ReadAction.compute(() -> {
                            int offset;
                            if (file2 instanceof LightVirtualFile || file2 instanceof HttpVirtualFile) {
                                return -1;
                            }
                            Document document = FileDocumentManager.getInstance().getDocument(file2);
                            if (document == null) {
                                return -1;
                            }
                            int l = Math.max(0, line);
                            int c = Math.max(0, column);
                            int n = offset = l < document.getLineCount() ? document.getLineStartOffset(l) + c : -1;
                            if (offset >= document.getTextLength()) {
                                offset = document.getTextLength() - 1;
                            }
                            return offset;
                        });
                    }
                };
            }

            public int getLine() {
                return line;
            }

            public int getOffset() {
                return (Integer)this.myOffset.getValue();
            }
        };
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        return XSourcePositionImpl.doCreateOpenFileDescriptor(project, this);
    }

    @NotNull
    public static OpenFileDescriptor createOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        Navigatable navigatable = position.createNavigatable(project);
        if (navigatable instanceof OpenFileDescriptor) {
            return (OpenFileDescriptor)navigatable;
        }
        return XSourcePositionImpl.doCreateOpenFileDescriptor(project, position);
    }

    @NotNull
    public static OpenFileDescriptor doCreateOpenFileDescriptor(@NotNull Project project, @NotNull XSourcePosition position) {
        return position.getOffset() != -1 ? new OpenFileDescriptor(project, position.getFile(), position.getOffset()) : new OpenFileDescriptor(project, position.getFile(), position.getLine(), 0);
    }

    public String toString() {
        return "XSourcePositionImpl[" + this.myFile + ":" + this.getLine() + "(" + this.getOffset() + ")]";
    }
}

