/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import org.jetbrains.annotations.NotNull;

public class QuickEvaluateAction
extends XDebuggerActionBase {
    public QuickEvaluateAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        return new QuickEvaluateHandlerWrapper(debuggerSupport.getQuickEvaluateHandler());
    }

    private static class QuickEvaluateHandlerWrapper
    extends DebuggerActionHandler {
        private final QuickEvaluateHandler myHandler;

        QuickEvaluateHandlerWrapper(QuickEvaluateHandler handler2) {
            this.myHandler = handler2;
        }

        @Override
        public void perform(@NotNull Project project, AnActionEvent event) {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor != null) {
                LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
                ValueLookupManager.getInstance(project).showHint(this.myHandler, editor, editor.logicalPositionToXY(logicalPosition), ValueHintType.MOUSE_CLICK_HINT);
            }
        }

        @Override
        public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
            if (!this.myHandler.isEnabled(project, event)) {
                return false;
            }
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return false;
            }
            return EditorGutter.KEY.getData(event.getDataContext()) == null;
        }
    }
}

