/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class ToggleLineBreakpointAction
extends XDebuggerActionBase
implements DumbAware,
Toggleable {
    public ToggleLineBreakpointAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        return debuggerSupport.getToggleLineBreakpointHandler();
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        if ("TouchBarGeneral".equals(event.getPlace())) {
            event.getPresentation().setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
        boolean selected = ToggleLineBreakpointAction.hasLineBreakpoint(event);
        event.getPresentation().putClientProperty("selected", (Object)selected);
    }

    private static boolean hasLineBreakpoint(@NotNull AnActionEvent e) {
        Project proj = e.getProject();
        if (proj == null) {
            return false;
        }
        XLineBreakpointType[] breakpointTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)proj).getBreakpointManager();
        for (XSourcePosition position : XDebuggerUtilImpl.getAllCaretsPositions(proj, e.getDataContext())) {
            for (XLineBreakpointType breakpointType : breakpointTypes) {
                int line;
                VirtualFile file2 = position.getFile();
                if (breakpointManager.findBreakpointAtLine(breakpointType, file2, line = position.getLine()) == null) continue;
                return true;
            }
        }
        return false;
    }
}

