/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerSmartStepIntoHandler
extends XDebuggerSuspendedActionHandler {
    private static final Logger LOG = Logger.getInstance(XDebuggerSmartStepIntoHandler.class);

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        return super.isEnabled(session2, dataContext) && session2.getDebugProcess().getSmartStepIntoHandler() != null;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        XSmartStepIntoHandler handler2 = session2.getDebugProcess().getSmartStepIntoHandler();
        XSourcePosition position = session2.getTopFramePosition();
        if (position == null || handler2 == null) {
            return;
        }
        FileEditor editor = FileEditorManager.getInstance((Project)session2.getProject()).getSelectedEditor(position.getFile());
        if (editor instanceof TextEditor) {
            XDebuggerSmartStepIntoHandler.doSmartStepInto(handler2, position, session2, ((TextEditor)editor).getEditor());
        }
    }

    private static <V extends XSmartStepIntoVariant> void doSmartStepInto(final XSmartStepIntoHandler<V> handler2, XSourcePosition position, final XDebugSession session2, Editor editor) {
        List variants = handler2.computeSmartStepVariants(position);
        if (variants.isEmpty()) {
            session2.stepInto();
            return;
        }
        if (variants.size() == 1) {
            session2.smartStepInto(handler2, (XSmartStepIntoVariant)variants.get(0));
            return;
        }
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<V>(handler2.getPopupTitle(position), variants){

            public Icon getIconFor(V aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(V value) {
                return value.getText();
            }

            public PopupStep onChosen(V selectedValue, boolean finalChoice) {
                session2.smartStepInto(handler2, selectedValue);
                highlighter.dropHighlight();
                return FINAL_CHOICE;
            }

            public void canceled() {
                highlighter.dropHighlight();
                super.canceled();
            }
        });
        popup2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selectedValue = ObjectUtils.doIfCast((Object)e.getSource(), JBList.class, it -> it.getSelectedValue());
                    XDebuggerSmartStepIntoHandler.highlightVariant((XSmartStepIntoVariant)ObjectUtils.tryCast((Object)selectedValue, XSmartStepIntoVariant.class), highlighter);
                }
            }
        });
        XDebuggerSmartStepIntoHandler.highlightVariant((XSmartStepIntoVariant)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((List)variants), XSmartStepIntoVariant.class), highlighter);
        DebuggerUIUtil.showPopupForEditorLine((JBPopup)popup2, editor, position.getLine());
    }

    private static void highlightVariant(@Nullable XSmartStepIntoVariant variant, @NotNull ScopeHighlighter highlighter) {
        TextRange range2;
        TextRange textRange = range2 = variant != null ? variant.getHighlightRange() : null;
        if (range2 != null) {
            highlighter.highlight((Pair<TextRange, List<TextRange>>)Pair.create((Object)range2, Collections.singletonList(range2)));
        }
    }
}

