/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.actions.handlers.XAddToWatchesFromEditorActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XEvaluateInConsoleFromEditorActionHandler
extends XAddToWatchesFromEditorActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        return super.isEnabled(session2, dataContext) && XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2) != null;
    }

    @Nullable
    private static ConsoleExecuteAction getConsoleExecuteAction(@NotNull XDebugSession session2) {
        return XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2.getConsoleView());
    }

    @Nullable
    public static ConsoleExecuteAction getConsoleExecuteAction(@Nullable ConsoleView consoleView) {
        if (!(consoleView instanceof LanguageConsoleView)) {
            return null;
        }
        List actions = ActionUtil.getActions((JComponent)((LanguageConsoleView)consoleView).getConsoleEditor().getComponent());
        ConsoleExecuteAction action = (ConsoleExecuteAction)((Object)ContainerUtil.findInstance((Iterable)actions, ConsoleExecuteAction.class));
        return action == null || !action.isEnabled() ? null : action;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        Promise rangeAndText;
        int selectionEnd;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (!(editor instanceof EditorEx)) {
            return;
        }
        int selectionStart = editor.getSelectionModel().getSelectionStart();
        if (selectionStart != (selectionEnd = editor.getSelectionModel().getSelectionEnd())) {
            TextRange textRange = new TextRange(selectionStart, selectionEnd);
            rangeAndText = Promises.resolvedPromise((Object)Pair.create((Object)textRange, (Object)editor.getDocument().getText(textRange)));
        } else {
            XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
            if (evaluator != null) {
                Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(session2.getProject(), editor.getDocument(), selectionStart, true);
                rangeAndText = expressionInfoPromise.then(expressionInfo -> {
                    if (expressionInfo == null) {
                        return null;
                    }
                    return Pair.create((Object)expressionInfo.getTextRange(), (Object)XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, editor.getDocument()));
                });
            } else {
                return;
            }
        }
        rangeAndText.onSuccess(textRangeStringPair -> ApplicationManager.getApplication().invokeLater(() -> {
            TextRange range2 = (TextRange)textRangeStringPair.getFirst();
            String text = (String)textRangeStringPair.getSecond();
            if (text == null) {
                return;
            }
            ConsoleExecuteAction action = XEvaluateInConsoleFromEditorActionHandler.getConsoleExecuteAction(session2);
            if (action != null) {
                action.execute(range2, text, (EditorEx)editor);
            }
        }));
    }
}

