/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkerPresentationDialog;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMarkObjectActionHandler
extends MarkObjectActionHandler {
    @Override
    public void perform(@NotNull Project project, AnActionEvent event) {
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session2 == null) {
            return;
        }
        XValueMarkers<?, ?> markers = ((XDebugSessionImpl)session2).getValueMarkers();
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(event.getDataContext());
        if (markers == null || node == null) {
            return;
        }
        XValue value = (XValue)node.getValueContainer();
        boolean detachedView = DebuggerUIUtil.isInDetachedTree(event);
        XDebuggerTreeState treeState = XDebuggerTreeState.saveState(node.getTree());
        ValueMarkup existing = markers.getMarkup(value);
        if (existing != null) {
            markers.unmarkValue(value);
        } else {
            ValueMarkerPresentationDialog dialog2 = new ValueMarkerPresentationDialog((Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT), node.getName(), markers.getAllMarkers().values());
            dialog2.show();
            ValueMarkup markup = dialog2.getConfiguredMarkup();
            if (dialog2.isOK() && markup != null) {
                markers.markValue(value, markup);
            }
        }
        if (detachedView) {
            node.getTree().rebuildAndRestore(treeState);
        }
        session2.rebuildViews();
    }

    @Override
    public boolean isEnabled(@NotNull Project project, AnActionEvent event) {
        XValueMarkers<?, ?> markers = XMarkObjectActionHandler.getValueMarkers(project);
        if (markers == null) {
            return false;
        }
        XValue value = XDebuggerTreeActionBase.getSelectedValue(event.getDataContext());
        return value != null && markers.canMarkValue(value);
    }

    @Override
    public boolean isMarked(@NotNull Project project, @NotNull AnActionEvent event) {
        XValueMarkers<?, ?> markers = XMarkObjectActionHandler.getValueMarkers(project);
        if (markers == null) {
            return false;
        }
        XValue value = XDebuggerTreeActionBase.getSelectedValue(event.getDataContext());
        return value != null && markers.getMarkup(value) != null;
    }

    @Override
    public boolean isHidden(@NotNull Project project, AnActionEvent event) {
        return XMarkObjectActionHandler.getValueMarkers(project) == null;
    }

    @Nullable
    private static XValueMarkers<?, ?> getValueMarkers(@NotNull Project project) {
        XDebugSession session2 = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session2 != null ? ((XDebugSessionImpl)session2).getValueMarkers() : null;
    }
}

