/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class RemoveBreakpointGutterIconAction
extends DumbAwareAction {
    private final XBreakpointBase<?, ?, ?> myBreakpoint;

    RemoveBreakpointGutterIconAction(XBreakpointBase<?, ?, ?> breakpoint) {
        super(XDebuggerBundle.message((String)"xdebugger.remove.line.breakpoint.action.text", (Object[])new Object[0]));
        this.myBreakpoint = breakpoint;
        AnAction action = ActionManager.getInstance().getAction("ToggleLineBreakpoint");
        this.copyShortcutFrom(action);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        InputEvent event = e.getInputEvent();
        if (!(event instanceof MouseEvent) || event.getModifiersEx() == 0 || SwingUtilities.isMiddleMouseButton((MouseEvent)event)) {
            XDebuggerUtilImpl.removeBreakpointWithConfirmation(this.myBreakpoint.getProject(), this.myBreakpoint);
        }
    }
}

