/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.lang.Language;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XExpressionImpl
implements XExpression {
    public static final XExpression EMPTY_EXPRESSION = XExpressionImpl.fromText("", EvaluationMode.EXPRESSION);
    public static final XExpression EMPTY_CODE_FRAGMENT = XExpressionImpl.fromText("", EvaluationMode.CODE_FRAGMENT);
    @NotNull
    private final String myExpression;
    private final Language myLanguage;
    private final String myCustomInfo;
    private final EvaluationMode myMode;

    public XExpressionImpl(@NotNull String expression, Language language, String customInfo) {
        this(expression, language, customInfo, EvaluationMode.EXPRESSION);
    }

    public XExpressionImpl(@NotNull String expression, Language language, String customInfo, @NotNull EvaluationMode mode) {
        this.myExpression = expression;
        this.myLanguage = language;
        this.myCustomInfo = customInfo;
        this.myMode = mode;
    }

    @NotNull
    public String getExpression() {
        return this.myExpression;
    }

    public Language getLanguage() {
        return this.myLanguage;
    }

    public String getCustomInfo() {
        return this.myCustomInfo;
    }

    @NotNull
    public EvaluationMode getMode() {
        return this.myMode;
    }

    @Contract(value="null -> null; !null -> !null")
    public static XExpressionImpl fromText(@Nullable String text) {
        return text != null ? new XExpressionImpl(text, null, null, EvaluationMode.EXPRESSION) : null;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static XExpressionImpl fromText(@Nullable String text, @NotNull EvaluationMode mode) {
        return text != null ? new XExpressionImpl(text, null, null, mode) : null;
    }

    public static XExpressionImpl changeMode(@NotNull XExpression expression, @NotNull EvaluationMode mode) {
        return new XExpressionImpl(expression.getExpression(), expression.getLanguage(), expression.getCustomInfo(), mode);
    }

    public String toString() {
        return this.myExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XExpressionImpl that = (XExpressionImpl)o;
        if (!Objects.equals(this.myCustomInfo, that.myCustomInfo)) {
            return false;
        }
        if (!this.myExpression.equals(that.myExpression)) {
            return false;
        }
        if (!Objects.equals(this.myLanguage, that.myLanguage)) {
            return false;
        }
        return this.myMode == that.myMode;
    }

    public int hashCode() {
        return Objects.hash(this.myExpression, this.myLanguage, this.myCustomInfo, this.myMode);
    }
}

