/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.popup.util.DetailController;
import com.intellij.ui.popup.util.DetailViewImpl;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.ui.popup.util.MasterController;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsCheckboxTree;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    private final Object myInitialBreakpoint;
    private final List<BreakpointPanelProvider> myBreakpointsPanelProviders;
    private BreakpointItemsTreeController myTreeController;
    final JLabel temp = new JLabel();
    private final MasterController myMasterController = new MasterController(){

        @Override
        public ItemWrapper[] getSelectedItems() {
            List<BreakpointItem> res2 = BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(false);
            return res2.toArray(new ItemWrapper[0]);
        }

        @Override
        public JLabel getPathLabel() {
            return BreakpointsDialog.this.temp;
        }
    };
    private final DetailController myDetailController = new DetailController(this.myMasterController);
    private final Collection<BreakpointItem> myBreakpointItems = new ArrayList<BreakpointItem>();
    private final SingleAlarm myRebuildAlarm = new SingleAlarm(new Runnable(){

        @Override
        public void run() {
            BreakpointsDialog.this.collectItems();
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
            BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
        }
    }, 100, this.myDisposable);
    private final List<XBreakpointGroupingRule> myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
    private final Set<XBreakpointGroupingRule> myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
    private final Disposable myListenerDisposable = Disposer.newDisposable();
    private final List<ToggleActionButton> myToggleRuleActions = new ArrayList<ToggleActionButton>();

    private XBreakpointManagerImpl getBreakpointManager() {
        return (XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager();
    }

    protected BreakpointsDialog(@NotNull Project project, Object breakpoint, @NotNull List<BreakpointPanelProvider> providers) {
        super(project);
        this.myProject = project;
        this.myBreakpointsPanelProviders = providers;
        this.myInitialBreakpoint = breakpoint;
        this.collectGroupingRules();
        this.collectItems();
        this.setTitle("Breakpoints");
        this.setModal(false);
        this.init();
        this.setOKButtonText("Done");
    }

    private String getSplitterProportionKey() {
        return this.getDimensionServiceKey() + ".splitter";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JBSplitter splitPane = new JBSplitter(0.3f);
        splitPane.setSplitterProportionKey(this.getSplitterProportionKey());
        splitPane.setFirstComponent(this.createMasterView());
        splitPane.setSecondComponent(this.createDetailView());
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    private JComponent createDetailView() {
        DetailViewImpl detailView = new DetailViewImpl(this.myProject);
        detailView.setEmptyLabel(XDebuggerBundle.message((String)"xbreakpoint.label.empty", (Object[])new Object[0]));
        this.myDetailController.setDetailView(detailView);
        return detailView;
    }

    void collectItems() {
        if (!this.myBreakpointsPanelProviders.isEmpty()) {
            this.disposeItems();
            this.myBreakpointItems.clear();
            for (BreakpointPanelProvider panelProvider : this.myBreakpointsPanelProviders) {
                panelProvider.provideBreakpointItems(this.myProject, this.myBreakpointItems);
            }
        }
    }

    void initSelection(Collection<BreakpointItem> breakpoints) {
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        if (settings != null && settings.getTreeState() != null) {
            settings.getTreeState().applyTo(this.myTreeController.getTreeView());
            if (this.myTreeController.getTreeView().getSelectionCount() == 0) {
                this.myTreeController.selectFirstBreakpointItem();
            }
        } else {
            TreeUtil.expandAll((JTree)this.myTreeController.getTreeView());
            this.myTreeController.selectFirstBreakpointItem();
        }
        this.selectBreakpoint(this.myInitialBreakpoint);
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getHelpAction()};
    }

    private JComponent createMasterView() {
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesEnabled){

            @Override
            public void nodeStateWillChangeImpl(CheckedTreeNode node) {
                if (node instanceof BreakpointItemNode) {
                    ((BreakpointItemNode)node).getBreakpointItem().saveState();
                }
                super.nodeStateWillChangeImpl(node);
            }

            @Override
            public void nodeStateDidChangeImpl(CheckedTreeNode node) {
                super.nodeStateDidChangeImpl(node);
                if (node instanceof BreakpointItemNode) {
                    BreakpointsDialog.this.myDetailController.doUpdateDetailView(true);
                }
            }

            @Override
            protected void selectionChangedImpl() {
                super.selectionChangedImpl();
                BreakpointsDialog.this.saveCurrentItem();
                BreakpointsDialog.this.myDetailController.updateDetailView();
            }
        };
        final BreakpointsCheckboxTree tree = new BreakpointsCheckboxTree(this.myProject, this.myTreeController){

            protected void onDoubleClick(CheckedTreeNode node) {
                if (node instanceof BreakpointsGroupNode) {
                    TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
                    if (this.isExpanded(path)) {
                        this.collapsePath(path);
                    } else {
                        this.expandPath(path);
                    }
                } else {
                    BreakpointsDialog.this.navigate(false);
                }
            }
        };
        tree.setHorizontalAutoScrollingEnabled(false);
        PopupHandler.installPopupHandler((JComponent)((Object)tree), (ActionGroup)new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ActionGroup group = new ActionGroup("Move to group", true){

                    @NotNull
                    public AnAction[] getChildren(@Nullable AnActionEvent e) {
                        Set<String> groups = BreakpointsDialog.this.getBreakpointManager().getAllGroups();
                        AnAction[] res2 = new AnAction[groups.size() + 3];
                        int i = 0;
                        res2[i++] = new MoveToGroupAction(null);
                        for (String group : groups) {
                            res2[i++] = new MoveToGroupAction(group);
                        }
                        res2[i++] = new Separator();
                        res2[i] = new MoveToGroupAction();
                        return res2;
                    }
                };
                ArrayList<Object> res2 = new ArrayList<Object>();
                res2.add(group);
                Object component = tree.getLastSelectedPathComponent();
                if (tree.getSelectionCount() == 1 && component instanceof BreakpointsGroupNode && ((BreakpointsGroupNode)((Object)component)).getGroup() instanceof XBreakpointCustomGroup) {
                    res2.add((Object)new SetAsDefaultGroupAction((XBreakpointCustomGroup)((Object)((BreakpointsGroupNode)((Object)component)).getGroup())));
                }
                if (tree.getSelectionCount() == 1 && component instanceof BreakpointItemNode) {
                    res2.add((Object)new EditDescriptionAction((XBreakpointBase)((BreakpointItemNode)((Object)component)).getBreakpointItem().getBreakpoint()));
                }
                return res2.toArray(AnAction.EMPTY_ARRAY);
            }
        }, (String)"unknown", (ActionManager)ActionManager.getInstance());
        new AnAction("BreakpointDialog.GoToSource"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }
        }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)((Object)tree), this.myDisposable);
        new AnAction("BreakpointDialog.ShowSource"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                BreakpointsDialog.this.navigate(true);
                BreakpointsDialog.this.close(0);
            }
        }.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)((Object)tree), this.myDisposable);
        DefaultActionGroup breakpointTypes = (DefaultActionGroup)((StreamEx)XBreakpointUtil.breakpointTypes().filter(XBreakpointType::isAddBreakpointButtonVisible)).map(x$0 -> new AddXBreakpointAction((XBreakpointType<?, ?>)x$0)).toListAndThen(DefaultActionGroup::new);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)tree)).setAddAction(button2 -> JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)breakpointTypes, DataManager.getInstance().getDataContext((Component)button2.getContextComponent()), JBPopupFactory.ActionSelectionAid.NUMBERING, false).show(button2.getPreferredPopupPoint())).setRemoveAction(button2 -> this.myTreeController.removeSelectedBreakpoints(this.myProject)).setRemoveActionUpdater(e -> {
            for (BreakpointItem item : this.myTreeController.getSelectedBreakpoints(true)) {
                if (!item.allowedToRemove()) continue;
                return true;
            }
            return false;
        }).setToolbarPosition(ActionToolbarPosition.TOP).setToolbarBorder((Border)JBUI.Borders.empty());
        this.myToggleRuleActions.forEach(arg_0 -> ((ToolbarDecorator)decorator).addExtraAction(arg_0));
        JPanel decoratedTree = decorator.createPanel();
        decoratedTree.setBorder((Border)JBUI.Borders.empty());
        JScrollPane pane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)((Object)tree));
        if (pane != null) {
            pane.setBorder(IdeBorderFactory.createBorder());
        }
        this.myTreeController.setTreeView((JTree)((Object)tree));
        this.myTreeController.buildTree(this.myBreakpointItems);
        this.initSelection(this.myBreakpointItems);
        this.myBreakpointsPanelProviders.forEach(provider -> provider.addListener(this.myRebuildAlarm::cancelAndRequest, this.myProject, this.myListenerDisposable));
        return decoratedTree;
    }

    private void navigate(boolean requestFocus) {
        this.myTreeController.getSelectedBreakpoints(false).stream().findFirst().ifPresent(b -> b.navigate(requestFocus));
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTreeController.getTreeView();
    }

    private void collectGroupingRules() {
        for (BreakpointPanelProvider provider : this.myBreakpointsPanelProviders) {
            provider.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.myRulesAvailable.sort(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
        this.myRulesEnabled.clear();
        XBreakpointsDialogState settings = this.getBreakpointManager().getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings == null || !settings.getSelectedGroupingRules().contains((Object)rule.getId()))) continue;
            this.myRulesEnabled.add(rule);
        }
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (rule.isAlwaysEnabled()) continue;
            this.myToggleRuleActions.add(new ToggleBreakpointGroupingRuleEnabledAction(rule));
        }
    }

    private void saveBreakpointsDialogState() {
        XBreakpointsDialogState dialogState = new XBreakpointsDialogState();
        this.saveTreeState(dialogState);
        List rulesEnabled = ContainerUtil.filter(this.myRulesEnabled, rule -> !rule.isAlwaysEnabled());
        dialogState.setSelectedGroupingRules((THashSet<String>)new THashSet((Collection)ContainerUtil.map((Collection)rulesEnabled, XBreakpointGroupingRule::getId)));
        this.getBreakpointManager().setBreakpointsDialogSettings(dialogState);
    }

    private void saveTreeState(XBreakpointsDialogState state) {
        JTree tree = this.myTreeController.getTreeView();
        state.setTreeState(TreeState.createOn((JTree)tree, (DefaultMutableTreeNode)((DefaultMutableTreeNode)tree.getModel().getRoot())));
    }

    protected void dispose() {
        this.saveCurrentItem();
        Disposer.dispose((Disposable)this.myListenerDisposable);
        this.saveBreakpointsDialogState();
        this.disposeItems();
        super.dispose();
    }

    private void disposeItems() {
        this.myBreakpointItems.forEach(BreakpointItem::dispose);
    }

    @Nullable
    protected String getHelpId() {
        return "reference.dialogs.breakpoints";
    }

    private void saveCurrentItem() {
        ItemWrapper item = this.myDetailController.getSelectedItem();
        if (item instanceof BreakpointItem) {
            ((BreakpointItem)item).saveState();
        }
    }

    public void toFront() {
        this.getWindow().setBounds(this.getWindow().getBounds());
        super.toFront();
    }

    public boolean selectBreakpoint(Object breakpoint) {
        if (breakpoint != null) {
            for (BreakpointItem item : this.myBreakpointItems) {
                if (item.getBreakpoint() != breakpoint) continue;
                this.myTreeController.selectBreakpointItem(item, null);
                return true;
            }
        }
        return false;
    }

    private class EditDescriptionAction
    extends AnAction {
        private final XBreakpointBase myBreakpoint;

        private EditDescriptionAction(XBreakpointBase breakpoint) {
            super("Edit description");
            this.myBreakpoint = breakpoint;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String description = Messages.showInputDialog((String)"", (String)"Edit Description", null, (String)this.myBreakpoint.getUserDescription(), null);
            if (description == null) {
                return;
            }
            this.myBreakpoint.setUserDescription(description);
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }
    }

    private class SetAsDefaultGroupAction
    extends AnAction {
        private final String myName;

        private SetAsDefaultGroupAction(XBreakpointCustomGroup group) {
            super(group.isDefault() ? "Unset as default" : "Set as default");
            this.myName = group.isDefault() ? null : group.getName();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BreakpointsDialog.this.getBreakpointManager().setDefaultGroup(this.myName);
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }
    }

    private class MoveToGroupAction
    extends AnAction {
        private final String myGroup;
        private final boolean myNewGroup;

        private MoveToGroupAction(String group) {
            super(group == null ? "<no group>" : group);
            this.myGroup = group;
            this.myNewGroup = false;
        }

        private MoveToGroupAction() {
            super("Create new...");
            this.myNewGroup = true;
            this.myGroup = null;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String groupName = this.myGroup;
            if (this.myNewGroup && (groupName = Messages.showInputDialog((String)"New group name", (String)"New Group", (Icon)AllIcons.Nodes.Folder)) == null) {
                return;
            }
            for (BreakpointItem item : BreakpointsDialog.this.myTreeController.getSelectedBreakpoints(true)) {
                Object breakpoint = item.getBreakpoint();
                if (!(breakpoint instanceof XBreakpointBase)) continue;
                ((XBreakpointBase)breakpoint).setGroup(groupName);
            }
            BreakpointsDialog.this.myTreeController.rebuildTree(BreakpointsDialog.this.myBreakpointItems);
        }
    }

    private class AddXBreakpointAction
    extends AnAction
    implements DumbAware {
        private final XBreakpointType<?, ?> myType;

        AddXBreakpointAction(XBreakpointType<?, ?> type) {
            this.myType = type;
            this.getTemplatePresentation().setIcon(type.getEnabledIcon());
            this.getTemplatePresentation().setText(type.getTitle());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BreakpointsDialog.this.saveCurrentItem();
            XBreakpoint breakpoint = this.myType.addBreakpoint(BreakpointsDialog.this.myProject, null);
            if (breakpoint != null) {
                BreakpointsDialog.this.selectBreakpoint(breakpoint);
            }
        }
    }

    private class ToggleBreakpointGroupingRuleEnabledAction
    extends ToggleActionButton {
        private final XBreakpointGroupingRule myRule;

        ToggleBreakpointGroupingRuleEnabledAction(XBreakpointGroupingRule rule) {
            super(rule.getPresentableName(), rule.getIcon());
            this.myRule = rule;
            this.getTemplatePresentation().setText(rule.getPresentableName());
        }

        public boolean isSelected(AnActionEvent e) {
            return BreakpointsDialog.this.myRulesEnabled.contains(this.myRule);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                BreakpointsDialog.this.myRulesEnabled.add(this.myRule);
            } else {
                BreakpointsDialog.this.myRulesEnabled.remove(this.myRule);
            }
            BreakpointsDialog.this.myTreeController.setGroupingRules(BreakpointsDialog.this.myRulesEnabled);
        }
    }
}

