/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointCustomGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class BreakpointsTreeCellRenderer {
    private static final SimpleTextAttributes SIMPLE_CELL_ATTRIBUTES_BOLD = SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.derive(1, null, null, null);

    BreakpointsTreeCellRenderer() {
    }

    private static void customizeRenderer(Project project, Object value, boolean selected, boolean expanded, ColoredTreeCellRenderer renderer2) {
        if (value instanceof BreakpointItemNode) {
            BreakpointItemNode node = (BreakpointItemNode)((Object)value);
            BreakpointItem breakpoint = node.getBreakpointItem();
            breakpoint.setupRenderer(renderer2, project, selected);
        } else if (value instanceof BreakpointsGroupNode) {
            Object group = ((BreakpointsGroupNode)((Object)value)).getGroup();
            renderer2.setIcon(group.getIcon(expanded));
            if (group instanceof XBreakpointCustomGroup && ((XBreakpointCustomGroup)((Object)group)).isDefault()) {
                renderer2.append(group.getName(), SIMPLE_CELL_ATTRIBUTES_BOLD);
            } else {
                renderer2.append(group.getName(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
            }
        }
    }

    public static class BreakpointsSimpleTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Project myProject;

        public BreakpointsSimpleTreeCellRenderer(Project project) {
            this.myProject = project;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value, selected, expanded, this);
        }
    }

    public static class BreakpointsCheckboxTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final Project myProject;

        public BreakpointsCheckboxTreeCellRenderer(Project project) {
            this.myProject = project;
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            BreakpointsTreeCellRenderer.customizeRenderer(this.myProject, value, selected, expanded, this.getTextRenderer());
        }
    }
}

