/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.concurrency.ResultConsumer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class XDebuggerTreeCreator
implements DebuggerTreeCreator<Pair<XValue, String>> {
    @NotNull
    private final Project myProject;
    private final XDebuggerEditorsProvider myProvider;
    private final XSourcePosition myPosition;
    private final XValueMarkers<?, ?> myMarkers;

    public XDebuggerTreeCreator(@NotNull Project project, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, XValueMarkers<?, ?> markers) {
        this.myProject = project;
        this.myProvider = editorsProvider;
        this.myPosition = sourcePosition;
        this.myMarkers = markers;
    }

    @Override
    @NotNull
    public Tree createTree(@NotNull Pair<XValue, String> descriptor) {
        XDebuggerTree tree = new XDebuggerTree(this.myProject, this.myProvider, this.myPosition, "XDebugger.Inspect.Tree.Popup", this.myMarkers);
        XValueNodeImpl root = new XValueNodeImpl(tree, null, (String)descriptor.getSecond(), (XValue)descriptor.getFirst());
        tree.setRoot(root, true);
        tree.setSelectionRow(0);
        tree.expandNodesOnLoad((Condition<TreeNode>)((Condition)node -> node == root));
        return tree;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Pair<XValue, String> descriptor) {
        return (String)descriptor.getSecond();
    }

    @Override
    public void createDescriptorByNode(Object node, ResultConsumer<Pair<XValue, String>> resultConsumer) {
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            resultConsumer.onSuccess((Object)Pair.create(valueNode.getValueContainer(), (Object)valueNode.getName()));
        }
    }
}

