/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class ValueLookupManager
implements EditorMouseMotionListener,
EditorMouseListener {
    public static final Key<Boolean> DISABLE_VALUE_LOOKUP = Key.create((String)"DISABLE_VALUE_LOOKUP");
    private final Project myProject;
    private final Alarm myAlarm;
    private AbstractValueHint myRequest = null;
    private final DebuggerSupport[] mySupports;
    private boolean myListening;

    public ValueLookupManager(@NotNull Project project) {
        this.myProject = project;
        this.mySupports = DebuggerSupport.getDebuggerSupports();
        this.myAlarm = new Alarm((Disposable)project);
    }

    public void startListening() {
        if (!this.myListening) {
            this.myListening = true;
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.myProject);
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseListener((EditorMouseListener)this, (Disposable)this.myProject);
        }
    }

    public void mouseExited(@NotNull EditorMouseEvent e) {
        this.myAlarm.cancelAllRequests();
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        ValueHintType type = AbstractValueHint.getHintType(e);
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA || DISABLE_VALUE_LOOKUP.get((UserDataHolder)editor) == Boolean.TRUE || type == null) {
            this.myAlarm.cancelAllRequests();
            return;
        }
        if (type == ValueHintType.MOUSE_OVER_HINT && !ApplicationManager.getApplication().isActive()) {
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (this.myRequest != null) {
            if (this.myRequest.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                return;
            }
            if (!this.myRequest.isKeepHint(editor, point)) {
                this.hideHint();
            }
        }
        for (DebuggerSupport support : this.mySupports) {
            QuickEvaluateHandler handler2 = support.getQuickEvaluateHandler();
            if (!handler2.isEnabled(this.myProject)) continue;
            this.requestHint(handler2, editor, point, type);
            break;
        }
    }

    private void requestHint(QuickEvaluateHandler handler2, Editor editor, Point point, @NotNull ValueHintType type) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        this.myAlarm.cancelAllRequests();
        if (type == ValueHintType.MOUSE_OVER_HINT) {
            if (Registry.is((String)"debugger.valueTooltipAutoShow")) {
                this.myAlarm.addRequest(() -> {
                    if (area.equals(editor.getScrollingModel().getVisibleArea())) {
                        this.showHint(handler2, editor, point, type);
                    }
                }, this.getDelay(handler2));
            }
        } else {
            this.showHint(handler2, editor, point, type);
        }
    }

    private int getDelay(QuickEvaluateHandler handler2) {
        int delay = handler2.getValueLookupDelay(this.myProject);
        if (this.myRequest != null && !this.myRequest.isHintHidden()) {
            delay = Math.max(100, delay);
        }
        return delay;
    }

    public void hideHint() {
        if (this.myRequest != null) {
            this.myRequest.hideHint();
            this.myRequest = null;
        }
    }

    public void showHint(@NotNull QuickEvaluateHandler handler2, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type) {
        PsiDocumentManager.getInstance((Project)this.myProject).performWhenAllCommitted(() -> this.doShowHint(handler2, editor, point, type));
    }

    private void doShowHint(@NotNull QuickEvaluateHandler handler2, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type) {
        Promise<AbstractValueHint> hintPromise;
        this.myAlarm.cancelAllRequests();
        if (editor.isDisposed() || !handler2.canShowHint(this.myProject)) {
            return;
        }
        if (this.myRequest != null && this.myRequest.isInsideHint(editor, point)) {
            return;
        }
        try {
            hintPromise = handler2.createValueHintAsync(this.myProject, editor, point, type);
        }
        catch (IndexNotReadyException e) {
            return;
        }
        hintPromise.onSuccess(hint -> {
            if (hint == null) {
                return;
            }
            if (this.myRequest != null && this.myRequest.equals(hint)) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!hint.canShowHint()) {
                    return;
                }
                this.hideHint();
                this.myRequest = hint;
                this.myRequest.invokeHint(() -> {
                    if (this.myRequest != null && this.myRequest == hint) {
                        this.myRequest = null;
                    }
                });
            });
        });
    }

    public static ValueLookupManager getInstance(Project project) {
        return (ValueLookupManager)ServiceManager.getService((Project)project, ValueLookupManager.class);
    }
}

