/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueMarkerProvider;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueMarkers<V extends XValue, M> {
    private final XValueMarkerProvider<V, M> myProvider;
    private final Map<M, ValueMarkup> myMarkers;

    private XValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        this.myProvider = provider;
        this.myMarkers = new HashMap<M, ValueMarkup>();
    }

    public static <V extends XValue, M> XValueMarkers<V, M> createValueMarkers(@NotNull XValueMarkerProvider<V, M> provider) {
        return new XValueMarkers<V, M>(provider);
    }

    @Nullable
    public ValueMarkup getMarkup(@NotNull XValue value) {
        Class valueClass = this.myProvider.getValueClass();
        if (!valueClass.isInstance(value)) {
            return null;
        }
        XValue v = (XValue)valueClass.cast(value);
        if (!this.myProvider.canMark(v)) {
            return null;
        }
        Object m = this.myProvider.getMarker(v);
        if (m == null) {
            return null;
        }
        return this.myMarkers.get(m);
    }

    public boolean canMarkValue(@NotNull XValue value) {
        Class valueClass = this.myProvider.getValueClass();
        if (!valueClass.isInstance(value)) {
            return false;
        }
        return this.myProvider.canMark((XValue)valueClass.cast(value));
    }

    public void markValue(@NotNull XValue value, @NotNull ValueMarkup markup) {
        this.myMarkers.entrySet().stream().filter(entry -> markup.getText().equals(((ValueMarkup)entry.getValue()).getText())).findFirst().ifPresent(entry -> this.myMarkers.remove(entry.getKey()));
        Object m = this.myProvider.markValue(value);
        this.myMarkers.put(m, markup);
    }

    public void unmarkValue(@NotNull XValue value) {
        XValue v = value;
        Object m = this.myProvider.getMarker(v);
        if (m != null) {
            this.myProvider.unmarkValue(v, m);
            this.myMarkers.remove(m);
        }
    }

    public Map<M, ValueMarkup> getAllMarkers() {
        return Collections.unmodifiableMap(this.myMarkers);
    }

    public void clear() {
        this.myMarkers.clear();
    }
}

