/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextViewer
extends EditorTextField {
    private final boolean myEmbeddedIntoDialogWrapper;

    public TextViewer(@NotNull String initialText, @NotNull Project project, boolean viewer) {
        this(TextViewer.createDocument(initialText, viewer), project, true, viewer);
    }

    public TextViewer(@NotNull String initialText, @NotNull Project project) {
        this(initialText, project, true);
    }

    public TextViewer(@NotNull Document document, @NotNull Project project, boolean embeddedIntoDialogWrapper, boolean viewer) {
        super(document, project, (FileType)FileTypes.PLAIN_TEXT, viewer, false);
        this.myEmbeddedIntoDialogWrapper = embeddedIntoDialogWrapper;
        this.setFontInheritedFromLAF(false);
    }

    private static Document createDocument(@NotNull String initialText, boolean viewer) {
        if (TextViewer.needSlashRSupport(initialText, viewer)) {
            return ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(initialText, true, false);
        }
        return EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)initialText));
    }

    @Override
    public void setText(@Nullable String text) {
        if (text != null) {
            if (TextViewer.needSlashRSupport(text, this.isViewer())) {
                Editor editor;
                if (!((DocumentImpl)this.getDocument()).setAcceptSlashR(true) && (editor = this.getEditor()) instanceof EditorEx) {
                    ((EditorEx)editor).reinitSettings();
                }
            } else {
                text = StringUtil.convertLineSeparators((String)text);
            }
        }
        super.setText(text);
    }

    private static boolean needSlashRSupport(String text, boolean viewer) {
        return !viewer && text.contains("\r");
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setHorizontalScrollbarVisible(true);
        editor.setCaretEnabled(true);
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.setEmbeddedIntoDialogWrapper(this.myEmbeddedIntoDialogWrapper);
        editor.getComponent().setPreferredSize(null);
        editor.getSettings().setUseSoftWraps(true);
        editor.setColorsScheme(DebuggerUIUtil.getColorScheme());
        return editor;
    }
}

