/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebugViewSessionListener;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.frame.XThreadsView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionTab
extends DebuggerSessionTabBase {
    public static final DataKey<XDebugSessionTab> TAB_KEY = DataKey.create((String)"XDebugSessionTab");
    private XWatchesViewImpl myWatchesView;
    private boolean myWatchesInVariables = Registry.is((String)"debugger.watches.in.variables");
    private final LinkedHashMap<String, XDebugView> myViews = new LinkedHashMap();
    @Nullable
    private XDebugSessionImpl mySession;
    private XDebugSessionData mySessionData;
    private final Runnable myRebuildWatchesRunnable = new Runnable(){

        @Override
        public void run() {
            if (XDebugSessionTab.this.myWatchesView != null) {
                XDebugSessionTab.this.myWatchesView.computeWatches();
            }
        }
    };

    @NotNull
    public static XDebugSessionTab create(@NotNull XDebugSessionImpl session2, @Nullable Icon icon, @Nullable ExecutionEnvironment environment, @Nullable RunContentDescriptor contentToReuse) {
        XDebugSessionTab oldTab;
        JComponent component;
        if (contentToReuse != null && SystemProperties.getBooleanProperty((String)"xdebugger.reuse.session.tab", (boolean)false) && (component = contentToReuse.getComponent()) != null && (oldTab = (XDebugSessionTab)TAB_KEY.getData(DataManager.getInstance().getDataContext((Component)component))) != null) {
            oldTab.setSession(session2, environment, icon);
            oldTab.attachToSession(session2);
            return oldTab;
        }
        XDebugSessionTab tab = new XDebugSessionTab(session2, icon, environment);
        tab.myRunContentDescriptor.setActivateToolWindowWhenAdded(contentToReuse == null || contentToReuse.isActivateToolWindowWhenAdded());
        return tab;
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        return this.myUi;
    }

    private XDebugSessionTab(@NotNull XDebugSessionImpl session2, @Nullable Icon icon, @Nullable ExecutionEnvironment environment) {
        super(session2.getProject(), "Debug", session2.getSessionName(), GlobalSearchScope.allScope((Project)session2.getProject()));
        this.setSession(session2, environment, icon);
        this.myUi.addContent(this.createFramesContent(), 0, PlaceInGrid.left, false);
        if (Registry.is((String)"debugger.new.threads.view")) {
            this.myUi.addContent(this.createThreadsContent(), 0, PlaceInGrid.right, true);
        }
        this.addVariablesAndWatches(session2);
        this.attachToSession(session2);
        DefaultActionGroup focus = new DefaultActionGroup();
        focus.add(ActionManager.getInstance().getAction("Debugger.FocusOnBreakpoint"));
        this.myUi.getOptions().setAdditionalFocusActions((ActionGroup)focus);
        this.myUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Content content = event.getContent();
                if (XDebugSessionTab.this.mySession != null && content.isSelected() && XDebugSessionTab.this.getWatchesContentId().equals(ViewImpl.ID.get((UserDataHolder)content))) {
                    XDebugSessionTab.this.myRebuildWatchesRunnable.run();
                }
            }
        }, (Disposable)this.myRunContentDescriptor);
        this.rebuildViews();
    }

    private void addVariablesAndWatches(@NotNull XDebugSessionImpl session2) {
        this.myUi.addContent(this.createVariablesContent(session2), 0, PlaceInGrid.center, false);
        if (!this.myWatchesInVariables) {
            this.myUi.addContent(this.createWatchesContent(session2), 0, PlaceInGrid.right, false);
        }
    }

    private void setSession(@NotNull XDebugSessionImpl session2, @Nullable ExecutionEnvironment environment, @Nullable Icon icon) {
        this.myEnvironment = environment;
        this.mySession = session2;
        this.mySessionData = session2.getSessionData();
        this.myConsole = session2.getConsoleView();
        List<AnAction> restartActionsList = session2.getRestartActions();
        AnAction[] restartActions = ContainerUtil.isEmpty(restartActionsList) ? AnAction.EMPTY_ARRAY : restartActionsList.toArray(AnAction.EMPTY_ARRAY);
        this.myRunContentDescriptor = new RunContentDescriptor(this.myConsole, session2.getDebugProcess().getProcessHandler(), this.myUi.getComponent(), session2.getSessionName(), icon, this.myRebuildWatchesRunnable, restartActions);
        this.myRunContentDescriptor.setRunnerLayoutUi(this.myUi);
        Disposer.register((Disposable)this.myRunContentDescriptor, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myRunContentDescriptor);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (XWatchesView.DATA_KEY.is(dataId)) {
            return this.myWatchesView;
        }
        if (TAB_KEY.is(dataId)) {
            return this;
        }
        if (XDebugSessionData.DATA_KEY.is(dataId)) {
            return this.mySessionData;
        }
        if (this.mySession != null) {
            if (XDebugSession.DATA_KEY.is(dataId)) {
                return this.mySession;
            }
            if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                return this.mySession.getConsoleView();
            }
        }
        return super.getData(dataId);
    }

    private Content createVariablesContent(@NotNull XDebugSessionImpl session2) {
        XVariablesView variablesView;
        if (this.myWatchesInVariables) {
            this.myWatchesView = new XWatchesViewImpl(session2, this.myWatchesInVariables);
            variablesView = this.myWatchesView;
        } else {
            variablesView = new XVariablesView(session2);
        }
        this.registerView("VariablesContent", variablesView);
        Content result2 = this.myUi.createContent("VariablesContent", (JComponent)variablesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), AllIcons.Debugger.VariablesTab, variablesView.getDefaultFocusedComponent());
        result2.setCloseable(false);
        ActionGroup group = XDebugSessionTab.getCustomizedActionGroup("XDebugger.Variables.Tree.Toolbar");
        result2.setActions(group, "DebuggerToolbar", (JComponent)((Object)variablesView.getTree()));
        return result2;
    }

    private Content createWatchesContent(@NotNull XDebugSessionImpl session2) {
        this.myWatchesView = new XWatchesViewImpl(session2, this.myWatchesInVariables);
        this.registerView("WatchesContent", this.myWatchesView);
        Content watchesContent = this.myUi.createContent("WatchesContent", (JComponent)this.myWatchesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), AllIcons.Debugger.Watch, this.myWatchesView.getDefaultFocusedComponent());
        watchesContent.setCloseable(false);
        return watchesContent;
    }

    @NotNull
    private Content createFramesContent() {
        XFramesView framesView = new XFramesView(this.myProject);
        this.registerView("FrameContent", framesView);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)framesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), AllIcons.Debugger.Frame, framesView.getDefaultFocusedComponent());
        framesContent.setCloseable(false);
        return framesContent;
    }

    @NotNull
    private Content createThreadsContent() {
        XThreadsView stacksView = new XThreadsView(this.myProject, this.mySession);
        this.registerView("ThreadsContent", stacksView);
        Content framesContent = this.myUi.createContent("ThreadsContent", (JComponent)stacksView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.threads.title", (Object[])new Object[0]), AllIcons.Debugger.Threads, (JComponent)((Object)stacksView.getDefaultFocusedComponent()));
        framesContent.setCloseable(false);
        return framesContent;
    }

    public void rebuildViews() {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            if (this.mySession != null) {
                this.mySession.rebuildViews();
            }
        });
    }

    public XWatchesView getWatchesView() {
        return this.myWatchesView;
    }

    private void attachToSession(@NotNull XDebugSessionImpl session2) {
        for (XDebugView view : this.myViews.values()) {
            XDebugSessionTab.attachViewToSession(session2, view);
        }
        XDebugTabLayouter layouter = session2.getDebugProcess().createTabLayouter();
        Content consoleContent = layouter.registerConsoleContent(this.myUi, this.myConsole);
        this.attachNotificationTo(consoleContent);
        layouter.registerAdditionalContent(this.myUi);
        RunContentBuilder.addAdditionalConsoleEditorActions(this.myConsole, consoleContent);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        DefaultActionGroup leftToolbar = new DefaultActionGroup();
        Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
        consoleContent.setHelpId(debugExecutor.getHelpId());
        if (this.myEnvironment != null) {
            leftToolbar.add(ActionManager.getInstance().getAction("Rerun"));
            List<AnAction> additionalRestartActions = session2.getRestartActions();
            if (!additionalRestartActions.isEmpty()) {
                leftToolbar.addAll((Collection)additionalRestartActions);
                leftToolbar.addSeparator();
            }
            leftToolbar.addAll(session2.getExtraActions());
        }
        leftToolbar.addAll(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.LeftToolbar"));
        for (AnAction action : session2.getExtraStopActions()) {
            leftToolbar.add(action, new Constraints(Anchor.AFTER, "Stop"));
        }
        leftToolbar.addSeparator();
        leftToolbar.add(this.myUi.getOptions().getLayoutActions());
        AnAction[] commonSettings = this.myUi.getOptions().getSettingsActionsList();
        DefaultActionGroup settings = new DefaultActionGroup(ActionsBundle.message((String)"group.XDebugger.settings.text", (Object[])new Object[0]), true);
        settings.getTemplatePresentation().setIcon(this.myUi.getOptions().getSettingsActions().getTemplatePresentation().getIcon());
        settings.addAll(commonSettings);
        leftToolbar.add((AnAction)settings);
        leftToolbar.addSeparator();
        leftToolbar.add(PinToolwindowTabAction.getPinAction());
        DefaultActionGroup topToolbar = new DefaultActionGroup();
        topToolbar.addAll(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar"));
        session2.getDebugProcess().registerAdditionalActions(leftToolbar, topToolbar, settings);
        this.myUi.getOptions().setLeftToolbar((ActionGroup)leftToolbar, "DebuggerToolbar");
        this.myUi.getOptions().setTopToolbar((ActionGroup)topToolbar, "DebuggerToolbar");
        if (this.myEnvironment != null) {
            this.initLogConsoles(this.myEnvironment.getRunProfile(), this.myRunContentDescriptor, this.myConsole);
        }
    }

    private static void attachViewToSession(@NotNull XDebugSessionImpl session2, @Nullable XDebugView view) {
        if (view != null) {
            XDebugViewSessionListener.attach(view, session2);
        }
    }

    public void detachFromSession() {
        assert (this.mySession != null);
        this.mySession = null;
    }

    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    public boolean isWatchesInVariables() {
        return this.myWatchesInVariables;
    }

    public void setWatchesInVariables(boolean watchesInVariables) {
        if (this.myWatchesInVariables != watchesInVariables) {
            this.myWatchesInVariables = watchesInVariables;
            Registry.get((String)"debugger.watches.in.variables").setValue(watchesInVariables);
            if (this.mySession != null) {
                this.removeContent("VariablesContent");
                this.removeContent("WatchesContent");
                this.addVariablesAndWatches(this.mySession);
                XDebugSessionTab.attachViewToSession(this.mySession, (XDebugView)this.myViews.get((Object)"VariablesContent"));
                XDebugSessionTab.attachViewToSession(this.mySession, (XDebugView)this.myViews.get((Object)"WatchesContent"));
                this.myUi.selectAndFocus(this.myUi.findContent("VariablesContent"), true, false);
                this.rebuildViews();
            }
        }
    }

    public static void showWatchesView(@NotNull XDebugSessionImpl session2) {
        XDebugSessionTab tab = session2.getSessionTab();
        if (tab != null) {
            XDebugSessionTab.showView(session2, tab.getWatchesContentId());
        }
    }

    public static void showFramesView(@Nullable XDebugSessionImpl session2) {
        XDebugSessionTab.showView(session2, "FrameContent");
    }

    private static void showView(@Nullable XDebugSessionImpl session2, String viewId) {
        XDebugSessionTab tab;
        XDebugSessionTab xDebugSessionTab = tab = session2 != null ? session2.getSessionTab() : null;
        if (tab != null) {
            Content content;
            RunnerContentUi ui;
            tab.toFront(false, null);
            tab.restoreContent(viewId);
            RunnerLayoutUi layoutUi = tab.getUi();
            if (layoutUi instanceof DataProvider && (ui = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)layoutUi)) != null && (content = ui.findContent(viewId)) != null) {
                ui.select(content, false);
            }
        }
    }

    public void toFront(boolean focus, @Nullable Runnable onShowCallback) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            RunContentManager manager;
            ToolWindow toolWindow;
            if (this.myRunContentDescriptor != null && (toolWindow = (manager = ExecutionManager.getInstance((Project)this.myProject).getContentManager()).getToolWindowByDescriptor(this.myRunContentDescriptor)) != null) {
                if (!toolWindow.isVisible()) {
                    toolWindow.show(() -> {
                        if (onShowCallback != null) {
                            onShowCallback.run();
                        }
                        this.myRebuildWatchesRunnable.run();
                    });
                }
                manager.selectRunContent(this.myRunContentDescriptor);
            }
        });
        if (focus) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean focusWnd = Registry.is((String)"debugger.mayBringFrameToFrontOnBreakpoint");
                ProjectUtil.focusProjectWindow(this.myProject, focusWnd);
                if (!focusWnd) {
                    AppIcon.getInstance().requestAttention(this.myProject, true);
                }
            });
        }
    }

    @NotNull
    private String getWatchesContentId() {
        return this.myWatchesInVariables ? "VariablesContent" : "WatchesContent";
    }

    private void registerView(String contentId, @NotNull XDebugView view) {
        this.myViews.put((Object)contentId, (Object)view);
        Disposer.register((Disposable)this.myRunContentDescriptor, (Disposable)view);
    }

    private void removeContent(String contentId) {
        this.restoreContent(contentId);
        this.myUi.removeContent(this.myUi.findContent(contentId), true);
        XDebugView view = (XDebugView)this.myViews.remove((Object)contentId);
        if (view != null) {
            Disposer.dispose((Disposable)view);
        }
    }

    private void restoreContent(String contentId) {
        RunnerContentUi ui;
        if (this.myUi instanceof DataProvider && (ui = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)this.myUi)) != null) {
            ui.restoreContent(contentId);
        }
    }
}

