/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final Logger LOG = Logger.getInstance(XDebuggerTreeRenderer.class);
    private final MyColoredTreeCellRenderer myLink = new MyColoredTreeCellRenderer();
    private boolean myHaveLink;
    private int myLinkOffset;
    private int myLinkWidth;
    private final MyLongTextHyperlink myLongTextLink = new MyLongTextHyperlink();
    private static Method ourGetRowXMethod = null;

    XDebuggerTreeRenderer() {
        this.getIpad().right = 0;
        this.myLink.getIpad().left = 0;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        int rowX;
        this.myHaveLink = false;
        this.myLink.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row2, hasFocus);
        XDebuggerTreeNode node = (XDebuggerTreeNode)value;
        node.appendToComponent((ColoredTextContainer)this);
        this.setIcon(node.getIcon());
        Rectangle treeVisibleRect = tree.getParent() instanceof JViewport ? ((JViewport)tree.getParent()).getViewRect() : tree.getVisibleRect();
        TreePath path = tree.getPathForRow(row2);
        int n = rowX = path != null ? XDebuggerTreeRenderer.getRowX((BasicTreeUI)tree.getUI(), row2, path.getPathCount() - 1) : 0;
        if (this.myHaveLink) {
            this.setupLinkDimensions(treeVisibleRect, rowX);
        } else {
            String rawValue;
            int visibleRectRightX = treeVisibleRect.x + treeVisibleRect.width;
            int notFittingWidth = rowX + super.getPreferredSize().width - visibleRectRightX;
            if (node instanceof XValueNodeImpl && notFittingWidth > 0 && !StringUtil.isEmpty((String)(rawValue = DebuggerUIUtil.getNodeRawValue((XValueNodeImpl)node))) && tree.isShowing()) {
                Point treeRightSideOnScreen = new Point(visibleRectRightX, treeVisibleRect.y);
                SwingUtilities.convertPointToScreen(treeRightSideOnScreen, tree);
                Rectangle screen = ScreenUtil.getScreenRectangle((Point)treeRightSideOnScreen);
                if (screen.x + screen.width < treeRightSideOnScreen.x + notFittingWidth) {
                    this.myLongTextLink.setupComponent(rawValue, ((XDebuggerTree)((Object)tree)).getProject());
                    this.append(this.myLongTextLink.getLinkText(), this.myLongTextLink.getTextAttributes(), (Object)this.myLongTextLink);
                    this.setupLinkDimensions(treeVisibleRect, rowX);
                    this.myLinkWidth = 0;
                }
            }
        }
        this.putClientProperty(ExpandableItemsHandler.RENDERER_DISABLED, this.myHaveLink);
    }

    private static int getRowX(BasicTreeUI ui, int row2, int depth) {
        if (ourGetRowXMethod == null) {
            try {
                ourGetRowXMethod = BasicTreeUI.class.getDeclaredMethod("getRowX", Integer.TYPE, Integer.TYPE);
                ourGetRowXMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                LOG.error((Throwable)e);
            }
        }
        if (ourGetRowXMethod != null) {
            try {
                return (Integer)ourGetRowXMethod.invoke((Object)ui, row2, depth);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return 0;
    }

    private void setupLinkDimensions(Rectangle treeVisibleRect, int rowX) {
        Dimension linkSize = this.myLink.getPreferredSize();
        this.myLinkWidth = linkSize.width;
        this.myLinkOffset = Math.min(super.getPreferredSize().width, treeVisibleRect.x + treeVisibleRect.width - this.myLinkWidth - rowX);
    }

    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (tag instanceof XDebuggerTreeNodeHyperlink && ((XDebuggerTreeNodeHyperlink)tag).alwaysOnScreen()) {
            this.myHaveLink = true;
            this.myLink.append(fragment, attributes, tag);
        } else {
            super.append(fragment, attributes, tag);
        }
    }

    protected void doPaint(Graphics2D g) {
        if (this.myHaveLink) {
            Graphics2D textGraphics = (Graphics2D)g.create(0, 0, this.myLinkOffset, this.getHeight());
            try {
                super.doPaint(textGraphics);
            }
            finally {
                textGraphics.dispose();
            }
            g.translate(this.myLinkOffset, 0);
            this.myLink.setHeight(this.getHeight());
            this.myLink.doPaint(g);
            g.translate(-this.myLinkOffset, 0);
        } else {
            super.doPaint(g);
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myHaveLink) {
            size.width += this.myLinkWidth;
        }
        return size;
    }

    @Nullable
    public Object getFragmentTagAt(int x) {
        if (this.myHaveLink) {
            return this.myLink.getFragmentTagAt(x - this.myLinkOffset);
        }
        return super.getFragmentTagAt(x);
    }

    private static class MyLongTextHyperlink
    extends XDebuggerTreeNodeHyperlink {
        private String myText;
        private Project myProject;

        MyLongTextHyperlink() {
            super(XDebuggerBundle.message((String)"node.test.show.full.value", (Object[])new Object[0]));
        }

        public void setupComponent(String text, Project project) {
            this.myText = text;
            this.myProject = project;
        }

        public boolean alwaysOnScreen() {
            return true;
        }

        public void onClick(MouseEvent event) {
            DebuggerUIUtil.showValuePopup((XFullValueEvaluator)new ImmediateFullValueEvaluator(this.myText), event, this.myProject, null);
            event.consume();
        }
    }

    private static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private int myHeight;

        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
        }

        public void setHeight(int height) {
            this.myHeight = height;
        }

        public int getHeight() {
            return this.myHeight;
        }
    }
}

