/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.util.Collections;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XDebuggerTreeSpeedSearch
extends TreeSpeedSearch {
    public final int SEARCH_DEPTH = Registry.intValue((String)"debugger.variablesView.rss.depth");

    XDebuggerTreeSpeedSearch(XDebuggerTree tree, Convertor<? super TreePath, String> toStringConvertor) {
        super(tree, toStringConvertor, true);
        this.setComparator(new SpeedSearchComparator(false, false){

            @Override
            public int matchingDegree(String pattern, String text) {
                return this.matchingFragments(pattern, text) != null ? 1 : 0;
            }

            @Override
            @Nullable
            public Iterable<TextRange> matchingFragments(@NotNull String pattern, @NotNull String text) {
                int index = StringUtil.indexOfIgnoreCase((String)text, (String)pattern, (int)0);
                return index >= 0 ? Collections.singleton(TextRange.from((int)index, (int)pattern.length())) : null;
            }
        });
    }

    @Override
    @Nullable
    protected Object findElement(String s) {
        TreePath element;
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        ListIterator<Object> it = this.getElementIterator(selectedIndex);
        String _s = s.trim();
        while (it.hasNext()) {
            element = (TreePath)it.next();
            if (!((JTree)this.myComponent).isVisible(element) || !this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element = (TreePath)it.next();
                if (!((JTree)this.myComponent).isVisible(element) || !this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        while (it.hasNext()) {
            element = (TreePath)it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            return element;
        }
        if (selectedIndex > 0) {
            while (it.hasPrevious()) {
                it.previous();
            }
            while (it.hasNext() && it.nextIndex() != selectedIndex) {
                element = (TreePath)it.next();
                if (!this.isMatchingElement(element, _s)) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected Object[] getAllElements() {
        XDebuggerTreeNode root = (XDebuggerTreeNode)ObjectUtils.tryCast((Object)((JTree)this.myComponent).getModel().getRoot(), XDebuggerTreeNode.class);
        int initialLevel = root != null ? root.getPath().getPathCount() : 0;
        return ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)((JTree)this.myComponent)).expand(n -> ((JTree)this.myComponent).isExpanded((TreePath)n) || n.getPathCount() - initialLevel < this.SEARCH_DEPTH)).traverse().filter(o -> !(o.getLastPathComponent() instanceof LoadingNode)).toList().toArray(new TreePath[0]);
    }
}

