/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValuePresentationUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValueTextRendererImpl
extends XValueTextRendererBase {
    private final ColoredTextContainer myText;

    public XValueTextRendererImpl(@NotNull ColoredTextContainer text) {
        this.myText = text;
    }

    public void renderValue(@NotNull String value) {
        XValuePresentationUtil.renderValue(value, this.myText, SimpleTextAttributes.REGULAR_ATTRIBUTES, -1, null);
    }

    @Override
    protected void renderRawValue(@NotNull String value, @NotNull TextAttributesKey key) {
        TextAttributes textAttributes = DebuggerUIUtil.getColorScheme().getAttributes(key);
        SimpleTextAttributes attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        this.myText.append(value, attributes);
    }

    public void renderStringValue(@NotNull String value, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
        TextAttributes textAttributes = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.STRING);
        SimpleTextAttributes attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
        this.myText.append("\"", attributes);
        XValuePresentationUtil.renderValue(value, this.myText, attributes, maxLength, additionalSpecialCharsToHighlight);
        this.myText.append("\"", attributes);
    }

    public void renderComment(@NotNull String comment) {
        this.myText.append(comment, SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    public void renderError(@NotNull String error) {
        this.myText.append(error, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public void renderSpecialSymbol(@NotNull String symbol) {
        this.myText.append(symbol, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

