/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.component;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InstancesTracker", storages={@Storage(value="$WORKSPACE_FILE$")})
public class InstancesTracker
implements PersistentStateComponent<MyState> {
    private final EventDispatcher<InstancesTrackerListener> myDispatcher = EventDispatcher.create(InstancesTrackerListener.class);
    private MyState myState = new MyState();

    public static InstancesTracker getInstance(@NotNull Project project) {
        return (InstancesTracker)project.getComponent(InstancesTracker.class);
    }

    public boolean isTracked(@NotNull String className) {
        return this.myState.classes.containsKey(className);
    }

    public boolean isBackgroundTrackingEnabled() {
        return this.myState.isBackgroundTrackingEnabled;
    }

    @Nullable
    public TrackingType getTrackingType(@NotNull String className) {
        return this.myState.classes.getOrDefault(className, null);
    }

    @NotNull
    public Map<String, TrackingType> getTrackedClasses() {
        return new HashMap<String, TrackingType>(this.myState.classes);
    }

    public void add(@NotNull String name, @NotNull TrackingType type) {
        if (type.equals(this.myState.classes.getOrDefault(name, null))) {
            return;
        }
        this.myState.classes.put(name, type);
        ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).classChanged(name, type);
    }

    public void remove(@NotNull String name) {
        TrackingType removed = this.myState.classes.remove(name);
        if (removed != null) {
            ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).classRemoved(name);
        }
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener listener2, @NotNull Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void removeTrackerListener(@NotNull InstancesTrackerListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void setBackgroundTackingEnabled(boolean state) {
        boolean oldState = this.myState.isBackgroundTrackingEnabled;
        if (state != oldState) {
            this.myState.isBackgroundTrackingEnabled = state;
            ((InstancesTrackerListener)this.myDispatcher.getMulticaster()).backgroundTrackingValueChanged(state);
        }
    }

    @Nullable
    public MyState getState() {
        return new MyState(this.myState);
    }

    public void loadState(@NotNull MyState state) {
        this.myState = new MyState(state);
    }

    static class MyState {
        boolean isBackgroundTrackingEnabled = false;
        @XCollection(elementTypes={Map.Entry.class})
        final Map<String, TrackingType> classes = new ConcurrentHashMap<String, TrackingType>();

        MyState() {
        }

        MyState(@NotNull MyState state) {
            this.isBackgroundTrackingEnabled = state.isBackgroundTrackingEnabled;
            for (Map.Entry<String, TrackingType> classState : state.classes.entrySet()) {
                this.classes.put(classState.getKey(), classState.getValue());
            }
        }
    }
}

