/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.memory.component.MemoryViewManager;
import com.intellij.xdebugger.memory.component.MemoryViewManagerState;
import com.intellij.xdebugger.memory.event.MemoryViewManagerListener;
import com.intellij.xdebugger.memory.tracking.TrackerForNewInstancesBase;
import com.intellij.xdebugger.memory.ui.ClassesTable;
import com.intellij.xdebugger.memory.ui.InstancesWindowBase;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.KeyboardUtils;
import com.intellij.xdebugger.memory.utils.SingleAlarmWithMutableDelay;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassesFilteredViewBase
extends BorderLayoutPanel
implements Disposable {
    protected static final double DELAY_BEFORE_INSTANCES_QUERY_COEFFICIENT = 0.5;
    protected static final double MAX_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    protected static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final String EMPTY_TABLE_CONTENT_WHEN_RUNNING = "The application is running";
    private static final String EMPTY_TABLE_CONTENT_WHEN_STOPPED = "Classes are not available";
    private static final int INITIAL_TIME = 0;
    protected final Project myProject;
    protected final SingleAlarmWithMutableDelay mySingleAlarm;
    private final SearchTextField myFilterTextField = new FilterTextField();
    private final ClassesTable myTable;
    private final MyDebuggerSessionListener myDebugSessionListener;
    private final AtomicInteger myTime = new AtomicInteger(0);
    private final AtomicInteger myLastUpdatingTime = new AtomicInteger(this.myTime.intValue());
    protected volatile boolean myIsActive;

    public ClassesFilteredViewBase(final @NotNull XDebugSession debugSession) {
        this.myProject = debugSession.getProject();
        debugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                debugSession.removeSessionListener((XDebugSessionListener)this);
            }
        });
        MemoryViewManagerState memoryViewManagerState = MemoryViewManager.getInstance().getState();
        this.myTable = this.createClassesTable(memoryViewManagerState);
        this.myTable.getEmptyText().setText(EMPTY_TABLE_CONTENT_WHEN_RUNNING);
        Disposer.register((Disposable)this, (Disposable)this.myTable);
        this.myTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char keyChar = e.getKeyChar();
                if (KeyboardUtils.isEnterKey(keyChar)) {
                    ClassesFilteredViewBase.this.handleClassSelection(ClassesFilteredViewBase.this.myTable.getSelectedClass());
                } else if (KeyboardUtils.isPartOfJavaClassName(keyChar) || KeyboardUtils.isBackSpace(keyChar)) {
                    String text = ClassesFilteredViewBase.this.myFilterTextField.getText();
                    String newText = KeyboardUtils.isBackSpace(keyChar) ? text.substring(0, text.length() - 1) : text + keyChar;
                    ClassesFilteredViewBase.this.myFilterTextField.setText(newText);
                    IdeFocusManager.getInstance((Project)ClassesFilteredViewBase.this.myProject).requestFocus((Component)ClassesFilteredViewBase.this.myFilterTextField, false);
                }
            }
        });
        this.myFilterTextField.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                this.dispatch(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                this.dispatch(e);
            }

            private void dispatch(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (ClassesFilteredViewBase.this.myTable.isInClickableMode() && (KeyboardUtils.isPartOfJavaClassName(e.getKeyChar()) || KeyboardUtils.isEnterKey(keyCode))) {
                    ClassesFilteredViewBase.this.myTable.exitClickableMode();
                    ClassesFilteredViewBase.this.updateClassesAndCounts(true);
                } else if (KeyboardUtils.isUpDownKey(keyCode) || KeyboardUtils.isEnterKey(keyCode)) {
                    ClassesFilteredViewBase.this.myTable.dispatchEvent(e);
                }
            }
        });
        this.myFilterTextField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ClassesFilteredViewBase.this.myTable.setFilterPattern(ClassesFilteredViewBase.this.myFilterTextField.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = state -> {
            this.myTable.setFilteringByDiffNonZero(state.isShowWithDiffOnly);
            this.myTable.setFilteringByInstanceExists(state.isShowWithInstancesOnly);
            this.myTable.setFilteringByTrackingState(state.isShowTrackedOnly);
            if (state.isAutoUpdateModeOn && this.myTable.isInClickableMode()) {
                this.updateClassesAndCounts(true);
            }
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.myDebugSessionListener = new MyDebuggerSessionListener();
        debugSession.addSessionListener((XDebugSessionListener)this.myDebugSessionListener, (Disposable)this);
        this.mySingleAlarm = new SingleAlarmWithMutableDelay(suspendContext -> {
            ApplicationManager.getApplication().invokeLater(() -> this.myTable.setBusy(true));
            this.scheduleUpdateClassesCommand(suspendContext);
        }, this);
        this.mySingleAlarm.setDelay((int)TimeUnit.MILLISECONDS.toMillis(500L));
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu menu2 = ClassesFilteredViewBase.createContextMenu();
                menu2.getComponent().show(comp, x, y);
            }
        });
        JScrollPane scroll = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable), (int)2);
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        group.setPopup(true);
        Presentation actionsPresentation = new Presentation("Memory View Settings");
        actionsPresentation.setIcon(AllIcons.General.GearPlain);
        ActionButton button2 = new ActionButton((AnAction)group, actionsPresentation, "unknown", (Dimension)new JBDimension(25, 25));
        BorderLayoutPanel topPanel = new BorderLayoutPanel();
        topPanel.addToCenter((Component)this.myFilterTextField);
        topPanel.addToRight((Component)button2);
        this.addToTop((Component)topPanel);
        this.addToCenter(scroll);
    }

    @NotNull
    protected ClassesTable createClassesTable(MemoryViewManagerState memoryViewManagerState) {
        return new ClassesTable(this.myProject, this, memoryViewManagerState.isShowWithDiffOnly, memoryViewManagerState.isShowWithInstancesOnly, memoryViewManagerState.isShowTrackedOnly);
    }

    protected abstract void scheduleUpdateClassesCommand(XSuspendContext var1);

    @Nullable
    protected TrackerForNewInstancesBase getStrategy(@NotNull TypeInfo ref) {
        return null;
    }

    protected void handleClassSelection(@Nullable TypeInfo ref) {
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (ref != null && debugSession != null && debugSession.isSuspended()) {
            if (!ref.canGetInstanceInfo()) {
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("Unable to get instances of class " + ref.name(), NotificationType.INFORMATION).notify(debugSession.getProject());
                return;
            }
            this.getInstancesWindow(ref, debugSession).show();
        }
    }

    protected abstract InstancesWindowBase getInstancesWindow(@NotNull TypeInfo var1, XDebugSession var2);

    protected void updateClassesAndCounts(boolean immediate) {
        ApplicationManager.getApplication().invokeLater(() -> {
            XSuspendContext suspendContext;
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
            if (this.shouldBeUpdated(debugSession) && (suspendContext = debugSession.getSuspendContext()) != null) {
                if (immediate) {
                    this.mySingleAlarm.cancelAndRequestImmediate(suspendContext);
                } else {
                    this.mySingleAlarm.cancelAndRequest(suspendContext);
                }
            }
        }, this.myProject.getDisposed());
    }

    @Contract(value="null -> false")
    private boolean shouldBeUpdated(@Nullable XDebugSession session2) {
        if (session2 instanceof XDebugSessionImpl && ((XDebugSessionImpl)session2).isReadOnly()) {
            return this.myLastUpdatingTime.get() == 0;
        }
        return session2 != null;
    }

    private static ActionPopupMenu createContextMenu() {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", group);
    }

    protected void doActivate() {
        this.myDebugSessionListener.setActive(true);
        if (this.isContentObsolete()) {
            if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                this.updateClassesAndCounts(true);
            } else {
                this.makeTableClickable();
            }
        }
    }

    private void makeTableClickable() {
        ApplicationManager.getApplication().invokeLater(() -> this.myTable.makeClickable(() -> this.updateClassesAndCounts(true)));
    }

    protected void doPause() {
        this.myDebugSessionListener.setActive(false);
        this.mySingleAlarm.cancelAllRequests();
    }

    private boolean isContentObsolete() {
        return this.myLastUpdatingTime.get() != this.myTime.get() && this.shouldBeUpdated(XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession());
    }

    protected void viewUpdated() {
        this.myLastUpdatingTime.set(this.myTime.get());
    }

    public ClassesTable getTable() {
        return this.myTable;
    }

    public Object getData(@NotNull String dataId) {
        return null;
    }

    @Nullable
    protected XDebugSessionListener getAdditionalSessionListener() {
        return null;
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean myIsActive = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean value) {
            this.myIsActive = value;
        }

        public void sessionResumed() {
            if (this.myIsActive) {
                XDebugSessionListener additionalSessionListener = ClassesFilteredViewBase.this.getAdditionalSessionListener();
                if (additionalSessionListener != null) {
                    additionalSessionListener.sessionResumed();
                }
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredViewBase.this.myTable.hideContent(ClassesFilteredViewBase.EMPTY_TABLE_CONTENT_WHEN_RUNNING));
                ClassesFilteredViewBase.this.mySingleAlarm.cancelAllRequests();
            }
        }

        public void sessionStopped() {
            XDebugSessionListener additionalSessionListener = ClassesFilteredViewBase.this.getAdditionalSessionListener();
            if (additionalSessionListener != null) {
                additionalSessionListener.sessionStopped();
            }
            ClassesFilteredViewBase.this.mySingleAlarm.cancelAllRequests();
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredViewBase.this.myTable.clean(ClassesFilteredViewBase.EMPTY_TABLE_CONTENT_WHEN_STOPPED));
        }

        public void sessionPaused() {
            ClassesFilteredViewBase.this.myTime.incrementAndGet();
            XDebugSessionListener additionalSessionListener = ClassesFilteredViewBase.this.getAdditionalSessionListener();
            if (additionalSessionListener != null) {
                additionalSessionListener.sessionPaused();
            }
            if (this.myIsActive && ClassesFilteredViewBase.this.isContentObsolete()) {
                if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                    ClassesFilteredViewBase.this.updateClassesAndCounts(false);
                } else {
                    ClassesFilteredViewBase.this.makeTableClickable();
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }
    }
}

