/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.xmlbeans.FileUtils;
import com.intellij.xml.actions.xmlbeans.GenerateInstanceDocumentFromSchemaDialog;
import com.intellij.xml.actions.xmlbeans.Xsd2InstanceUtils;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GenerateInstanceDocumentFromSchemaAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        boolean enabled = GenerateInstanceDocumentFromSchemaAction.isAcceptableFile(file2);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        GenerateInstanceDocumentFromSchemaDialog dialog2 = new GenerateInstanceDocumentFromSchemaDialog(project, file2);
        dialog2.setOkAction(() -> GenerateInstanceDocumentFromSchemaAction.doAction(project, dialog2));
        dialog2.show();
    }

    public static void doAction(Project project, GenerateInstanceDocumentFromSchemaDialog dialog2) {
        String xml;
        String pathToUse;
        FileDocumentManager.getInstance().saveAllDocuments();
        LinkedList<String> parameters = new LinkedList<String>();
        String url = dialog2.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(relativeFile);
        if (!(file2 instanceof XmlFile)) {
            Messages.showErrorDialog((Project)project, (String)(" (" + file2.getFileType().getName() + ")"), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        if (!dialog2.enableRestrictionCheck()) {
            parameters.add("-nopvr");
        }
        if (!dialog2.enableUniquenessCheck()) {
            parameters.add("-noupa");
        }
        parameters.add("-dl");
        try {
            final File tempDir = FileUtil.createTempFile((String)"xsd2inst", (String)"");
            tempDir.delete();
            tempDir.mkdir();
            pathToUse = tempDir.getPath() + File.separatorChar + Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)file2, (Map<String, String>)new THashMap(), new Xsd2InstanceUtils.SchemaReferenceProcessor(){

                @Override
                public void processSchema(String schemaFileName, byte[] schemaContent) {
                    try {
                        String fullFileName = tempDir.getPath() + File.separatorChar + schemaFileName;
                        FileUtils.saveStreamContentAsFile(fullFileName, new ByteArrayInputStream(schemaContent));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            return;
        }
        parameters.add(pathToUse);
        parameters.add("-name");
        parameters.add(dialog2.getElementName());
        try {
            xml = Xsd2InstanceUtils.generate(ArrayUtil.toStringArray(parameters));
        }
        catch (IllegalArgumentException e) {
            Messages.showErrorDialog((Project)project, (String)StringUtil.getMessage((Throwable)e), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        String xmlFileName = relativeFileDir.getPath() + File.separatorChar + dialog2.getOutputFileName();
        try {
            File xmlFile = new File(xmlFileName);
            FileUtil.writeToFile((File)xmlFile, (String)xml);
            VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xmlFile));
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)("Could not save generated XML document: " + StringUtil.getMessage((Throwable)e)), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
        }
    }

    static boolean isAcceptableFileForGenerateSchemaFromInstanceDocument(VirtualFile virtualFile) {
        return virtualFile != null && "xsd".equalsIgnoreCase(virtualFile.getExtension());
    }

    public static boolean isAcceptableFile(VirtualFile file2) {
        return GenerateInstanceDocumentFromSchemaAction.isAcceptableFileForGenerateSchemaFromInstanceDocument(file2);
    }
}

