/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xml.breadcrumbs.BreadcrumbsXmlWrapper;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class BreadcrumbsInitializingActivity
implements StartupActivity,
DumbAware {
    public void runActivity(final @NotNull Project project) {
        if (project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || project.isDisposed()) {
            return;
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyFileEditorManagerListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project);
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(project), (Disposable)project);
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> BreadcrumbsInitializingActivity.reinitBreadcrumbsInAllEditors(project));
    }

    private static void reinitBreadcrumbsInAllEditors(@NotNull Project project) {
        if (project.isDisposed()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, virtualFile);
        }
    }

    private static void reinitBreadcrumbsComponent(@NotNull FileEditorManager fileEditorManager, @NotNull VirtualFile file2) {
        boolean above = EditorSettingsExternalizable.getInstance().isBreadcrumbsAbove();
        for (FileEditor fileEditor : fileEditorManager.getAllEditors(file2)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            BreadcrumbsXmlWrapper wrapper2 = BreadcrumbsXmlWrapper.getBreadcrumbsComponent(editor);
            if (BreadcrumbsInitializingActivity.isSuitable(textEditor, file2)) {
                if (wrapper2 != null) {
                    if (wrapper2.breadcrumbs.above != above) {
                        BreadcrumbsInitializingActivity.remove(fileEditorManager, fileEditor, wrapper2);
                        wrapper2.breadcrumbs.above = above;
                        BreadcrumbsInitializingActivity.add(fileEditorManager, fileEditor, wrapper2);
                    }
                    wrapper2.queueUpdate();
                    continue;
                }
                BreadcrumbsInitializingActivity.registerWrapper(fileEditorManager, fileEditor, new BreadcrumbsXmlWrapper(editor));
                continue;
            }
            if (wrapper2 == null) continue;
            BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper2);
        }
    }

    private static boolean isSuitable(@NotNull TextEditor editor, @NotNull VirtualFile file2) {
        if (file2 instanceof HttpVirtualFile || !editor.isValid()) {
            return false;
        }
        for (FileBreadcrumbsCollector collector : (FileBreadcrumbsCollector[])FileBreadcrumbsCollector.EP_NAME.getExtensions((AreaInstance)editor.getEditor().getProject())) {
            if (!collector.handlesFile(file2) || !collector.isShownForFile(editor.getEditor(), file2)) continue;
            return true;
        }
        return false;
    }

    private static void add(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        if (wrapper2.breadcrumbs.above) {
            manager.addTopComponent(editor, (JComponent)wrapper2);
        } else {
            manager.addBottomComponent(editor, (JComponent)wrapper2);
        }
    }

    private static void remove(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        if (wrapper2.breadcrumbs.above) {
            manager.removeTopComponent(editor, (JComponent)wrapper2);
        } else {
            manager.removeBottomComponent(editor, (JComponent)wrapper2);
        }
    }

    private static void registerWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        BreadcrumbsInitializingActivity.add(fileEditorManager, fileEditor, wrapper2);
        Disposer.register((Disposable)fileEditor, () -> BreadcrumbsInitializingActivity.disposeWrapper(fileEditorManager, fileEditor, wrapper2));
    }

    private static void disposeWrapper(@NotNull FileEditorManager fileEditorManager, @NotNull FileEditor fileEditor, @NotNull BreadcrumbsXmlWrapper wrapper2) {
        BreadcrumbsInitializingActivity.remove(fileEditorManager, fileEditor, wrapper2);
        Disposer.dispose((Disposable)wrapper2);
    }

    private static class MyVirtualFileListener
    implements VirtualFileListener {
        private final Project myProject;

        MyVirtualFileListener(@NotNull Project project) {
            this.myProject = project;
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file2;
            FileEditorManager fileEditorManager;
            if ("name".equals(event.getPropertyName()) && !this.myProject.isDisposed() && (fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)).isFileOpen(file2 = event.getFile())) {
                BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(fileEditorManager, file2);
            }
        }
    }

    private static class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        private MyFileEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            BreadcrumbsInitializingActivity.reinitBreadcrumbsComponent(source, file2);
        }
    }
}

