/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.codeInsight.daemon.impl.tagTreeHighlighting.XmlTagTreeHighlightingUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Gray;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.breadcrumbs.BreadcrumbListener;
import com.intellij.xml.breadcrumbs.BreadcrumbsComponent;
import com.intellij.xml.breadcrumbs.BreadcrumbsForceShownSettings;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import com.intellij.xml.breadcrumbs.PsiBreadcrumbs;
import com.intellij.xml.breadcrumbs.PsiCrumb;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class BreadcrumbsXmlWrapper
extends JComponent
implements Disposable {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Editor Breadcrumb Updater", (int)1);
    final PsiBreadcrumbs breadcrumbs = new PsiBreadcrumbs();
    private final Project myProject;
    private Editor myEditor;
    private Collection<RangeHighlighter> myHighlighed;
    private final VirtualFile myFile;
    private boolean myUserCaretChange = true;
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("Breadcrumbs.Queue", 200, true, (JComponent)((Object)this.breadcrumbs));
    private final List<BreadcrumbListener> myBreadcrumbListeners = new ArrayList<BreadcrumbListener>();
    private final Update myUpdate = new Update(this){

        public void run() {
            BreadcrumbsXmlWrapper.this.updateCrumbs();
        }

        public boolean canEat(Update update) {
            return true;
        }
    };
    private CancellablePromise<?> myAsyncUpdateProgress = null;
    private final FileBreadcrumbsCollector myBreadcrumbsCollector;
    public static final Key<BreadcrumbsXmlWrapper> BREADCRUMBS_COMPONENT_KEY = new Key("BREADCRUMBS_KEY");
    private static final Iterable<? extends Crumb> EMPTY_BREADCRUMBS = ContainerUtil.emptyIterable();

    public BreadcrumbsXmlWrapper(@NotNull Editor editor) {
        this.myEditor = editor;
        this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, (Object)this);
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addPropertyChangeListener(this::updateEditorFont, this);
        }
        Project project = editor.getProject();
        assert (project != null);
        this.myProject = project;
        this.myFile = FileDocumentManager.getInstance().getFile(this.myEditor.getDocument());
        FileStatusManager manager = FileStatusManager.getInstance((Project)project);
        manager.addFileStatusListener(new FileStatusListener(){

            public void fileStatusesChanged() {
                BreadcrumbsXmlWrapper.this.queueUpdate();
            }
        }, (Disposable)this);
        CaretListener caretListener = new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (BreadcrumbsXmlWrapper.this.myUserCaretChange) {
                    BreadcrumbsXmlWrapper.this.queueUpdate();
                }
                BreadcrumbsXmlWrapper.this.myUserCaretChange = true;
            }
        };
        editor.getCaretModel().addCaretListener(caretListener, (Disposable)this);
        this.myBreadcrumbsCollector = FileBreadcrumbsCollector.findBreadcrumbsCollector((Project)this.myProject, (VirtualFile)this.myFile);
        if (this.myFile != null) {
            this.myBreadcrumbsCollector.watchForChanges(this.myFile, editor, (Disposable)this, () -> this.queueUpdate());
        }
        this.breadcrumbs.onHover(this::itemHovered);
        this.breadcrumbs.onSelect(this::itemSelected);
        this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(this.myEditor));
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.breadcrumbs), (boolean)true);
        pane.setVerticalScrollBarPolicy(21);
        pane.getHorizontalScrollBar().setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add("Center", pane);
        EditorGutter gutter = editor.getGutter();
        if (gutter instanceof EditorGutterComponentEx) {
            final EditorGutterComponentEx gutterComponent = (EditorGutterComponentEx)gutter;
            MouseEventAdapter<EditorGutterComponentEx> mouseListener = new MouseEventAdapter<EditorGutterComponentEx>(gutterComponent){

                @NotNull
                protected MouseEvent convert(@NotNull MouseEvent event) {
                    return 4.convert((MouseEvent)event, (Component)gutterComponent);
                }
            };
            ComponentAdapter resizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent event) {
                    BreadcrumbsXmlWrapper.this.breadcrumbs.updateBorder(gutterComponent.getWhitespaceSeparatorOffset());
                    BreadcrumbsXmlWrapper.this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(BreadcrumbsXmlWrapper.this.myEditor));
                }
            };
            this.addComponentListener(resizeListener);
            gutterComponent.addComponentListener(resizeListener);
            this.breadcrumbs.addMouseListener((MouseListener)mouseListener);
            Disposer.register((Disposable)this, () -> this.lambda$new$1(resizeListener, gutterComponent, (MouseEventAdapter)mouseListener));
            this.breadcrumbs.updateBorder(gutterComponent.getWhitespaceSeparatorOffset());
        } else {
            this.breadcrumbs.updateBorder(0);
        }
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)((Object)this.breadcrumbs), (Activatable)this.myQueue));
        Disposer.register((Disposable)this, (Disposable)this.myQueue);
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myQueue.setPassThrough(true);
        }
        this.queueUpdate();
    }

    private void updateCrumbs() {
        if (this.myEditor == null || this.myFile == null || this.myEditor.isDisposed()) {
            return;
        }
        if (this.myAsyncUpdateProgress != null) {
            this.myAsyncUpdateProgress.cancel();
        }
        Document document = this.myEditor.getDocument();
        int offset = this.myEditor.getCaretModel().getOffset();
        Boolean forcedShown = BreadcrumbsForceShownSettings.getForcedShown(this.myEditor);
        this.myAsyncUpdateProgress = ReadAction.nonBlocking(() -> this.myBreadcrumbsCollector.computeCrumbs(this.myFile, document, offset, forcedShown)).withDocumentsCommitted(this.myProject).expireWhen(() -> Disposer.isDisposed((Disposable)this)).finishOnUiThread(ModalityState.any(), _crumbs -> {
            Iterable<? extends Crumb> crumbs = this.breadcrumbs.isShowing() || ApplicationManager.getApplication().isHeadlessEnvironment() ? _crumbs : EMPTY_BREADCRUMBS;
            this.breadcrumbs.setFont(BreadcrumbsXmlWrapper.getNewFont(this.myEditor));
            this.breadcrumbs.setCrumbs(crumbs);
            this.notifyListeners(crumbs);
        }).submit((Executor)ourExecutor);
        this.myAsyncUpdateProgress.onProcessed(__ -> {
            this.myAsyncUpdateProgress = null;
        });
    }

    public void queueUpdate() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(this.myUpdate);
    }

    public void addBreadcrumbListener(BreadcrumbListener listener2, Disposable parentDisposable) {
        this.myBreadcrumbListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myBreadcrumbListeners.remove(listener2));
    }

    private void notifyListeners(@NotNull Iterable<? extends Crumb> breadcrumbs) {
        for (BreadcrumbListener listener2 : this.myBreadcrumbListeners) {
            listener2.breadcrumbsChanged(breadcrumbs);
        }
    }

    @Deprecated
    public JComponent getComponent() {
        return this;
    }

    private void itemSelected(Crumb crumb, InputEvent event) {
        if (event == null || !(crumb instanceof NavigatableCrumb)) {
            return;
        }
        NavigatableCrumb navigatableCrumb = (NavigatableCrumb)crumb;
        this.navigate(navigatableCrumb, event.isShiftDown() || event.isMetaDown());
    }

    public void navigate(NavigatableCrumb crumb, boolean withSelection) {
        this.myUserCaretChange = false;
        crumb.navigate(this.myEditor, withSelection);
    }

    private void itemHovered(Crumb crumb, InputEvent event) {
        if (!Registry.is((String)"editor.breadcrumbs.highlight.on.hover")) {
            return;
        }
        HighlightManager hm = HighlightManager.getInstance((Project)this.myProject);
        if (this.myHighlighed != null) {
            for (RangeHighlighter highlighter : this.myHighlighed) {
                hm.removeSegmentHighlighter(this.myEditor, highlighter);
            }
            this.myHighlighed = null;
        }
        if (crumb instanceof NavigatableCrumb) {
            Color background;
            Color color;
            TextRange range2 = ((NavigatableCrumb)crumb).getHighlightRange();
            if (range2 == null) {
                return;
            }
            TextAttributes attributes = new TextAttributes();
            CrumbPresentation p = PsiCrumb.getPresentation(crumb);
            Color color2 = color = p == null ? null : p.getBackgroundColor(false, false, false);
            if (color == null) {
                color = BreadcrumbsComponent.ButtonSettings.getBackgroundColor((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            }
            if (color == null) {
                color = UIUtil.getLabelBackground();
            }
            attributes.setBackgroundColor(XmlTagTreeHighlightingUtil.makeTransparent(color, (background = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.CARET_ROW_COLOR)) != null ? background : Gray._200, 0.3));
            this.myHighlighed = new ArrayList<RangeHighlighter>(1);
            int flags = 7;
            hm.addOccurrenceHighlight(this.myEditor, range2.getStartOffset(), range2.getEndOffset(), attributes, flags, this.myHighlighed, null);
        }
    }

    @Nullable
    public static BreadcrumbsXmlWrapper getBreadcrumbsComponent(@NotNull Editor editor) {
        return (BreadcrumbsXmlWrapper)editor.getUserData(BREADCRUMBS_COMPONENT_KEY);
    }

    public void dispose() {
        if (this.myEditor != null) {
            this.myEditor.putUserData(BREADCRUMBS_COMPONENT_KEY, null);
        }
        this.myEditor = null;
        this.breadcrumbs.setCrumbs(EMPTY_BREADCRUMBS);
        this.notifyListeners(EMPTY_BREADCRUMBS);
    }

    private void updateEditorFont(PropertyChangeEvent event) {
        if ("fontSize".equals(event.getPropertyName())) {
            this.queueUpdate();
        }
    }

    private static Font getNewFont(Editor editor) {
        Font font = editor == null || Registry.is((String)"editor.breadcrumbs.system.font") ? UIUtil.getLabelFont() : BreadcrumbsXmlWrapper.getEditorFont(editor);
        return UISettings.getInstance().getUseSmallLabelsOnTabs() ? RelativeFont.SMALL.derive(font) : font;
    }

    private static Font getEditorFont(Editor editor) {
        return ComplementaryFontsRegistry.getFontAbleToDisplay(97, 0, editor.getColorsScheme().getFontPreferences(), null).getFont();
    }

    private /* synthetic */ void lambda$new$1(ComponentAdapter resizeListener, EditorGutterComponentEx gutterComponent, MouseEventAdapter mouseListener) {
        this.removeComponentListener(resizeListener);
        gutterComponent.removeComponentListener(resizeListener);
        this.breadcrumbs.removeMouseListener((MouseListener)mouseListener);
    }
}

