/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFileSearcher {
    private final MultiMap<Module, PsiFile> myFiles = new MultiMap();
    private final MultiMap<VirtualFile, PsiFile> myJars = new MultiMap();
    private final MultiMap<VirtualFile, PsiFile> myVirtualFiles = new MultiMap();
    @Nullable
    private final Module myModule;
    @NotNull
    private final Project myProject;

    public ConfigFileSearcher(@Nullable Module module, @NotNull Project project) {
        this.myModule = module;
        this.myProject = project;
    }

    public void search() {
        this.searchWithFiles();
    }

    public List<PsiFile> searchWithFiles() {
        this.myFiles.clear();
        this.myJars.clear();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (PsiFile file2 : this.search(this.myModule, this.myProject)) {
            files2.add(file2);
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(file2.getVirtualFile());
            if (jar != null) {
                this.myJars.putValue((Object)jar, (Object)file2);
                continue;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
            if (module != null) {
                this.myFiles.putValue((Object)module, (Object)file2);
                continue;
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            this.myVirtualFiles.putValue((Object)virtualFile.getParent(), (Object)psiManager.findFile(virtualFile));
        }
        return files2;
    }

    public abstract Set<PsiFile> search(@Nullable Module var1, @NotNull Project var2);

    public MultiMap<Module, PsiFile> getFilesByModules() {
        return this.myFiles;
    }

    public MultiMap<VirtualFile, PsiFile> getJars() {
        return this.myJars;
    }

    public MultiMap<VirtualFile, PsiFile> getVirtualFiles() {
        return this.myVirtualFiles;
    }
}

