/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dtd;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleFieldCache;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.scope.processor.FilterElementProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptorEx;
import com.intellij.xml.impl.ExternalDocumentValidator;
import com.intellij.xml.impl.dtd.XmlElementDescriptorImpl;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNSDescriptorImpl
implements XmlNSDescriptorEx,
Validator<XmlDocument>,
DumbAware {
    private XmlElement myElement;
    private XmlFile myDescriptorFile;
    private static final SimpleFieldCache<CachedValue<Map<String, XmlElementDescriptor>>, XmlNSDescriptorImpl> myCachedDeclsCache = new SimpleFieldCache<CachedValue<Map<String, XmlElementDescriptor>>, XmlNSDescriptorImpl>(){

        protected final CachedValue<Map<String, XmlElementDescriptor>> compute(XmlNSDescriptorImpl xmlNSDescriptor) {
            return xmlNSDescriptor.doBuildDeclarationMap();
        }

        protected final CachedValue<Map<String, XmlElementDescriptor>> getValue(XmlNSDescriptorImpl xmlNSDescriptor) {
            return xmlNSDescriptor.myCachedDecls;
        }

        protected final void putValue(CachedValue<Map<String, XmlElementDescriptor>> cachedValue, XmlNSDescriptorImpl xmlNSDescriptor) {
            xmlNSDescriptor.myCachedDecls = cachedValue;
        }
    };
    private volatile CachedValue<Map<String, XmlElementDescriptor>> myCachedDecls;
    private static final XmlUtil.DuplicationInfoProvider<XmlElementDecl> XML_ELEMENT_DECL_PROVIDER = new XmlUtil.DuplicationInfoProvider<XmlElementDecl>(){

        @Override
        public String getName(@NotNull XmlElementDecl psiElement) {
            return psiElement.getName();
        }

        @Override
        @NotNull
        public String getNameKey(@NotNull XmlElementDecl psiElement, @NotNull String name) {
            return name;
        }

        @Override
        @NotNull
        public PsiElement getNodeForMessage(@NotNull XmlElementDecl psiElement) {
            return psiElement.getNameElement();
        }
    };

    public XmlFile getDescriptorFile() {
        return this.myDescriptorFile;
    }

    public XmlElementDescriptor[] getElements() {
        Collection<XmlElementDescriptor> declarations = this.buildDeclarationMap().values();
        return declarations.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    private Map<String, XmlElementDescriptor> buildDeclarationMap() {
        return (Map)((CachedValue)myCachedDeclsCache.get((Object)this)).getValue();
    }

    private CachedValue<Map<String, XmlElementDescriptor>> doBuildDeclarationMap() {
        return CachedValuesManager.getManager((Project)this.myElement.getProject()).createCachedValue(() -> {
            ArrayList result2 = new ArrayList();
            this.myElement.processElements((PsiElementProcessor)new FilterElementProcessor((ElementFilter)new ClassFilter(XmlElementDecl.class), result2), this.getDeclaration());
            LinkedHashMap<String, XmlElementDescriptorImpl> ret = new LinkedHashMap<String, XmlElementDescriptorImpl>((int)((double)result2.size() * 1.5));
            THashSet dependencies = new THashSet(1);
            dependencies.add(this.myDescriptorFile);
            for (XmlElementDecl xmlElementDecl : result2) {
                PsiFile dependingElementContainingFile;
                String name = xmlElementDecl.getName();
                if (name == null || ret.containsKey(name)) continue;
                ret.put(name, new XmlElementDescriptorImpl(xmlElementDecl));
                PsiElement dependingElement = (PsiElement)xmlElementDecl.getUserData(XmlElement.DEPENDING_ELEMENT);
                if (dependingElement == null || (dependingElementContainingFile = dependingElement.getContainingFile()) == null) continue;
                dependencies.add(dependingElementContainingFile);
            }
            return new CachedValueProvider.Result(ret, dependencies.toArray());
        }, false);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        String name = tag.getName();
        return this.getElementDescriptor(name);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        XmlElementDescriptor descriptor;
        XmlElement element;
        XmlDoctype doctype;
        XmlProlog prolog;
        XmlProlog xmlProlog = prolog = document != null ? document.getProlog() : null;
        if (prolog != null && (doctype = prolog.getDoctype()) != null && (element = doctype.getNameElement()) != null && (descriptor = this.getElementDescriptor(element.getText())) != null) {
            return new XmlElementDescriptor[]{descriptor};
        }
        return this.getElements();
    }

    public final XmlElementDescriptor getElementDescriptor(String name) {
        return this.buildDeclarationMap().get(name);
    }

    public PsiElement getDeclaration() {
        return this.myElement;
    }

    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getName() {
        return this.myDescriptorFile.getName();
    }

    public void init(PsiElement element) {
        this.myElement = (XmlElement)element;
        this.myDescriptorFile = (XmlFile)element.getContainingFile();
        if (this.myElement instanceof XmlFile) {
            this.myElement = ((XmlFile)this.myElement).getDocument();
        }
    }

    @NotNull
    public Object[] getDependencies() {
        return new Object[]{this.myElement, ExternalResourceManager.getInstance()};
    }

    @Override
    public void validate(@NotNull XmlDocument document, @NotNull Validator.ValidationHost host) {
        if (document.getLanguage() == DTDLanguage.INSTANCE) {
            final ArrayList decls = new ArrayList(3);
            XmlUtil.processXmlElements((XmlElement)document, new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element instanceof XmlElementDecl) {
                        decls.add((XmlElementDecl)element);
                    }
                    return true;
                }
            }, false);
            XmlUtil.doDuplicationCheckForElements((PsiElement[])((PsiElement[])decls.toArray(new XmlElementDecl[0])), new HashMap(decls.size()), XML_ELEMENT_DECL_PROVIDER, (Validator.ValidationHost)host);
            return;
        }
        ExternalDocumentValidator.doValidation(document, host);
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return this.getElementDescriptor(localName);
    }
}

