/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.schema;

import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiFileNsDescriptor
implements XsdNsDescriptor {
    private final List<? extends XmlNSDescriptorImpl> myDescriptors;

    public MultiFileNsDescriptor(List<? extends XmlNSDescriptorImpl> descriptors) {
        this.myDescriptors = descriptors;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        return this.getFirst(descriptor -> descriptor.getElementDescriptor(tag));
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        return (XmlElementDescriptor[])this.myDescriptors.stream().flatMap(descriptor -> Arrays.stream(descriptor.getRootElementsDescriptors(document))).toArray();
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myDescriptors.get(0).getDescriptorFile();
    }

    public PsiElement getDeclaration() {
        return null;
    }

    public String getName(PsiElement context) {
        return null;
    }

    public String getName() {
        return null;
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Object[] getDependencies() {
        return this.myDescriptors.stream().flatMap(descriptor -> Arrays.stream(descriptor.getDependencies())).toArray();
    }

    @Override
    @Nullable
    public TypeDescriptor getTypeDescriptor(String name, XmlTag context) {
        return this.getFirst(descriptor -> descriptor.getTypeDescriptor(name, context));
    }

    @Override
    @Nullable
    public TypeDescriptor getTypeDescriptor(XmlTag descriptorTag) {
        return this.getFirst(descriptor -> descriptor.getTypeDescriptor(descriptorTag));
    }

    private <T> T getFirst(Function<? super XmlNSDescriptorImpl, ? extends T> function) {
        for (XmlNSDescriptorImpl xmlNSDescriptorImpl : this.myDescriptors) {
            XmlNSDescriptorImpl t = function.apply(xmlNSDescriptorImpl);
            if (t == null) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public boolean processTagsInNamespace(String[] tagNames, PsiElementProcessor<? super XmlTag> processor2) {
        for (XmlNSDescriptorImpl xmlNSDescriptorImpl : this.myDescriptors) {
            if (xmlNSDescriptorImpl.processTagsInNamespace(tagNames, processor2)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public XmlElementDescriptor getElementDescriptor(String localName, String namespace, Set<? super XmlNSDescriptorImpl> visited, boolean reference) {
        return this.getFirst(descriptor -> descriptor.getElementDescriptor(localName, namespace, visited, reference));
    }

    @Override
    @Nullable
    public XmlAttributeDescriptor getAttribute(String localName, String namespace, XmlTag context) {
        return this.getFirst(descriptor -> descriptor.getAttribute(localName, namespace, context));
    }

    @Override
    @Nullable
    public TypeDescriptor findTypeDescriptor(String localName, String namespace) {
        return this.getFirst(descriptor -> descriptor.findTypeDescriptor(localName, namespace));
    }

    @Override
    @Nullable
    public XmlTag findGroup(String name) {
        return this.getFirst(descriptor -> descriptor.findGroup(name));
    }

    @Override
    @Nullable
    public XmlTag findAttributeGroup(String name) {
        return this.getFirst(descriptor -> descriptor.findAttributeGroup(name));
    }
}

