/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import org.jetbrains.annotations.NotNull;

public abstract class XmlIndex<V>
extends FileBasedIndexExtension<String, V> {
    protected static GlobalSearchScope createFilter(Project project) {
        final GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project);
        return new GlobalSearchScope(project){

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                return projectScope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                return true;
            }

            public boolean contains(@NotNull VirtualFile file2) {
                VirtualFile parent = file2.getParent();
                return parent != null && (parent.getName().equals("standardSchemas") || projectScope.contains(file2));
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        return EnumeratorStringDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                return XmlFileType.INSTANCE.equals(file2.getFileType()) && "xsd".equals(file2.getExtension());
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }
}

