/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFormatUtil {
    private static final List<PsiElement> EMPTY_PSI_ELEMENT_LIST = new ArrayList<PsiElement>();
    private static final String[] IGNORABLE_ERROR_MESSAGES = new String[]{XmlErrorMessages.message("xml.parsing.closing.tag.matches.nothing", new Object[0]), XmlErrorMessages.message("xml.parsing.closing.tag.name.missing", new Object[0])};

    private TemplateFormatUtil() {
    }

    @NotNull
    static List<PsiElement> findAllMarkupLanguageElementsInside(PsiElement outerLangElement) {
        PsiFile file2 = outerLangElement.getContainingFile();
        if (file2 != null && file2.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)file2.getViewProvider();
            return TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, false);
        }
        return EMPTY_PSI_ELEMENT_LIST;
    }

    @NotNull
    static List<PsiElement> findAllTemplateLanguageElementsInside(@NotNull PsiElement outerLangElement, @NotNull TemplateLanguageFileViewProvider viewProvider) {
        return TemplateFormatUtil.findAllElementsInside(outerLangElement.getTextRange(), viewProvider, true);
    }

    @NotNull
    static List<PsiElement> findAllElementsInside(@NotNull TextRange range2, @NotNull TemplateLanguageFileViewProvider viewProvider, boolean fromTemplate) {
        return TemplateFormatUtil.findAllElementsInside(range2, viewProvider, viewProvider.getBaseLanguage(), fromTemplate ? viewProvider.getBaseLanguage() : viewProvider.getTemplateDataLanguage());
    }

    @NotNull
    public static List<PsiElement> findAllElementsInside(TextRange range2, TemplateLanguageFileViewProvider viewProvider, Language templateLanguage, Language language) {
        ArrayList<PsiElement> matchingElements = new ArrayList<PsiElement>();
        PsiElement currElement = viewProvider.findElementAt(range2.getStartOffset(), language);
        while (currElement instanceof OuterLanguageElement) {
            currElement = currElement.getNextSibling();
        }
        if (currElement != null) {
            currElement = TemplateFormatUtil.findTopmostElementInRange(currElement, range2);
            Pair<Integer, PsiElement> result2 = TemplateFormatUtil.addElementSequence(currElement, templateLanguage, range2, matchingElements, templateLanguage == language);
            int lastOffset = (Integer)result2.first;
            assert (lastOffset >= 0) : "Failed to process elements in range: " + range2;
            if (lastOffset < range2.getEndOffset()) {
                List<PsiElement> moreElements = TemplateFormatUtil.findAllElementsInside(new TextRange(lastOffset, range2.getEndOffset()), viewProvider, templateLanguage, language);
                matchingElements.addAll(moreElements);
            }
        }
        return matchingElements;
    }

    private static Pair<Integer, PsiElement> addElementSequence(PsiElement startElement, Language templateLanguage, TextRange range2, List<? super PsiElement> targetList, boolean fromTemplate) {
        PsiElement child2;
        PsiElement currElement;
        int lastOffset = -1;
        for (currElement = startElement; currElement != null && (lastOffset = currElement.getTextRange().getEndOffset()) <= range2.getEndOffset(); currElement = currElement.getNextSibling()) {
            boolean isTemplateLanguage = templateLanguage.isKindOf(currElement.getLanguage());
            if (fromTemplate != isTemplateLanguage) continue;
            targetList.add((PsiElement)currElement);
        }
        if (currElement != null && currElement.getTextRange().intersects(range2) && (child2 = currElement.getFirstChild()) != null) {
            TemplateFormatUtil.addElementSequence(child2, templateLanguage, range2, targetList, fromTemplate);
        }
        return new Pair((Object)lastOffset, (Object)currElement);
    }

    @NotNull
    public static PsiElement findTopmostElementInRange(@NotNull PsiElement original, TextRange fitToRange) {
        PsiElement prevElement = original;
        for (PsiElement currElement = original; currElement != null; currElement = currElement.getParent()) {
            if (currElement instanceof PsiFile || !fitToRange.contains(currElement.getTextRange())) {
                if (!fitToRange.contains(prevElement.getTextRange())) {
                    return original;
                }
                return prevElement;
            }
            prevElement = currElement;
        }
        return original;
    }

    static List<Block> mergeBlocks(List<Block> originalBlocks, List<? extends Block> blocksToMerge, TextRange range2) throws FragmentedTemplateException {
        int n;
        int n2;
        if (blocksToMerge.isEmpty()) {
            return originalBlocks;
        }
        ArrayList<Block> result2 = new ArrayList<Block>();
        if (originalBlocks.isEmpty()) {
            for (Block block : blocksToMerge) {
                if (!range2.contains(block.getTextRange())) continue;
                result2.add(block);
            }
            return result2;
        }
        ArrayList<TextRange> originalRanges = new ArrayList<TextRange>();
        for (Block originalBlock : originalBlocks) {
            originalRanges.add(originalBlock.getTextRange());
        }
        int n3 = range2.getStartOffset();
        Iterator<Block> originalBlockIterator = originalBlocks.iterator();
        while (originalBlockIterator.hasNext()) {
            Block mergeableBlock;
            Block originalBlock = originalBlockIterator.next();
            int startOffset = originalBlock.getTextRange().getStartOffset();
            if (n2 < startOffset && (n2 = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, n2, startOffset)) < startOffset) {
                n2 = TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, n2, startOffset);
            }
            if ((mergeableBlock = TemplateFormatUtil.getBlockContaining(blocksToMerge, originalRanges, originalBlock.getTextRange())) != null) {
                if (mergeableBlock.getTextRange().getStartOffset() < n2) continue;
                result2.add(mergeableBlock);
                n2 = mergeableBlock.getTextRange().getEndOffset();
                continue;
            }
            if (startOffset < n2) continue;
            result2.add(originalBlock);
            originalBlockIterator.remove();
            n2 = originalBlock.getTextRange().getEndOffset();
        }
        if (n2 < range2.getEndOffset() && (n = TemplateFormatUtil.fillGap(originalRanges, blocksToMerge, result2, n2, range2.getEndOffset())) < range2.getEndOffset()) {
            TemplateFormatUtil.fillGap(originalRanges, originalBlocks, result2, n, range2.getEndOffset());
        }
        return result2;
    }

    private static int fillGap(List<? extends TextRange> originalRanges, List<? extends Block> blocks, List<? super Block> result2, int startOffset, int endOffset) throws FragmentedTemplateException {
        return TemplateFormatUtil.fillGap(null, originalRanges, blocks, result2, startOffset, endOffset, 0);
    }

    private static int fillGap(@Nullable Block parent, List<? extends TextRange> originalRanges, List<? extends Block> blocks, List<? super Block> result2, int startOffset, int endOffset, int depth) throws FragmentedTemplateException {
        int lastOffset = startOffset;
        TextRange currRange = new TextRange(lastOffset, endOffset);
        for (Block block : blocks) {
            if (lastOffset == endOffset || block.getTextRange().getStartOffset() > endOffset) {
                return lastOffset;
            }
            if (currRange.contains(block.getTextRange())) {
                result2.add((Block)block);
                if (parent != null && block instanceof IndentInheritingBlock) {
                    ((IndentInheritingBlock)block).setIndent(parent.getIndent());
                }
                lastOffset = block.getTextRange().getEndOffset();
                currRange = new TextRange(lastOffset, endOffset);
                continue;
            }
            if (!currRange.intersects(block.getTextRange()) || !TemplateFormatUtil.intersectsOneOf(block.getTextRange(), originalRanges)) continue;
            List subBlocks = block.getSubBlocks();
            if (block instanceof TemplateLanguageBlock && ((TemplateLanguageBlock)block).containsErrorElements()) {
                throw new FragmentedTemplateException();
            }
            lastOffset = TemplateFormatUtil.fillGap(block, originalRanges, subBlocks, result2, lastOffset, endOffset, depth + 1);
            currRange = new TextRange(lastOffset, endOffset);
        }
        return lastOffset;
    }

    public static boolean intersectsOneOf(TextRange blockRange, List<? extends TextRange> originalRanges) {
        return TemplateFormatUtil.rangesContain(originalRanges, 0, originalRanges.size() - 1, blockRange.getStartOffset()) || TemplateFormatUtil.rangesContain(originalRanges, 0, originalRanges.size() - 1, blockRange.getEndOffset());
    }

    static boolean rangesContain(List<? extends TextRange> ranges, int startIndex, int endIndex, int offset) {
        if (endIndex < startIndex || ranges.size() <= startIndex || ranges.size() <= endIndex) {
            return false;
        }
        int startOffset = ranges.get(startIndex).getStartOffset();
        int endOffset = ranges.get(endIndex).getEndOffset();
        if (offset < startOffset || offset > endOffset) {
            return false;
        }
        if (startIndex == endIndex) {
            return true;
        }
        int midIndex = (endIndex + startIndex) / 2;
        return TemplateFormatUtil.rangesContain(ranges, startIndex, midIndex, offset) || TemplateFormatUtil.rangesContain(ranges, midIndex + 1, endIndex, offset);
    }

    private static Block getBlockContaining(List<? extends Block> blockList, List<? extends TextRange> originalRanges, TextRange range2) {
        return TemplateFormatUtil.getBlockContaining(blockList, originalRanges, range2, 0);
    }

    @Nullable
    private static Block getBlockContaining(List<? extends Block> blockList, List<? extends TextRange> originalRanges, TextRange range2, int depth) {
        for (Block block : blockList) {
            Block containingBlock;
            if (!block.getTextRange().contains(range2)) continue;
            if (TemplateFormatUtil.intersectsOneOf(block.getTextRange(), originalRanges) && (containingBlock = TemplateFormatUtil.getBlockContaining(block.getSubBlocks(), originalRanges, range2, depth + 1)) != null) {
                return containingBlock;
            }
            return block;
        }
        return null;
    }

    @Nullable
    public static Block buildTemplateLanguageBlock(@NotNull OuterLanguageElement outerElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) {
        try {
            FormattingModel model;
            Language language;
            FormattingModelBuilder builder2;
            PsiFile file2 = outerElement.getContainingFile();
            FileViewProvider viewProvider = outerElement.getContainingFile().getViewProvider();
            if (viewProvider instanceof TemplateLanguageFileViewProvider && (builder2 = LanguageFormatting.INSTANCE.forContext(language = outerElement.getLanguage(), (PsiElement)outerElement)) instanceof AbstractXmlTemplateFormattingModelBuilder && (model = ((AbstractXmlTemplateFormattingModelBuilder)builder2).createTemplateFormattingModel(file2, (TemplateLanguageFileViewProvider)viewProvider, outerElement, settings, indent)) != null) {
                return model.getRootBlock();
            }
        }
        catch (FragmentedTemplateException fragmentedTemplateException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isErrorElement(@NotNull PsiElement element) {
        if (element instanceof PsiErrorElement) {
            String description = ((PsiErrorElement)element).getErrorDescription();
            for (String ignorableMessage : IGNORABLE_ERROR_MESSAGES) {
                if (!ignorableMessage.equals(description)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

