/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.template.formatter.TemplateLanguageBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TemplateXmlBlock
extends XmlBlock
implements IndentInheritingBlock {
    private final AbstractXmlTemplateFormattingModelBuilder myBuilder;
    private Indent myIndent;
    private static final List<Block> EMPTY_BLOCK_LIST = new ArrayList<Block>();

    public TemplateXmlBlock(AbstractXmlTemplateFormattingModelBuilder builder2, ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy, indent, textRange);
        this.myBuilder = builder2;
    }

    @Override
    protected XmlBlock createSimpleChild(ASTNode child2, Indent indent, Wrap wrap, Alignment alignment) {
        return this.myBuilder.createXmlBlock(child2, wrap, alignment, this.myXmlFormattingPolicy, indent, child2.getTextRange());
    }

    @Override
    protected XmlTagBlock createTagBlock(ASTNode child2, Indent indent, Wrap wrap, Alignment alignment) {
        return this.myBuilder.createXmlTagBlock(child2, wrap, alignment, this.myXmlFormattingPolicy, indent);
    }

    @Override
    protected Indent getChildDefaultIndent() {
        Indent indent = super.getChildDefaultIndent();
        if (indent == null) {
            indent = Indent.getNoneIndent();
        }
        return indent;
    }

    protected List<Block> buildChildrenNoMerge() {
        return super.buildChildren();
    }

    @Override
    protected List<Block> buildChildren() {
        try {
            List<Block> childBlocks = this.patchTopLevelChildBlocks(this.buildChildrenNoMerge());
            return this.myBuilder.mergeWithTemplateBlocks(childBlocks, this.myXmlFormattingPolicy.getSettings(), this.myXmlFormattingPolicy, this.getChildDefaultIndent());
        }
        catch (FragmentedTemplateException fte) {
            return EMPTY_BLOCK_LIST;
        }
    }

    private List<Block> patchTopLevelChildBlocks(List<Block> originalBlocks) {
        if (this.myNode.getPsi() instanceof PsiFile) {
            ArrayList<Block> patchedBlocks = new ArrayList<Block>();
            for (Block block : originalBlocks) {
                if (block == originalBlocks.get(0) && block instanceof TemplateXmlBlock) {
                    patchedBlocks.addAll(((TemplateXmlBlock)block).buildChildrenNoMerge());
                    continue;
                }
                patchedBlocks.add(block);
            }
            return patchedBlocks;
        }
        return originalBlocks;
    }

    @Override
    public void setIndent(Indent indent) {
        this.myIndent = indent;
    }

    @Override
    public Indent getIndent() {
        return this.myIndent != null ? this.myIndent : super.getIndent();
    }

    @Override
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child1 instanceof TemplateLanguageBlock && child2 instanceof TemplateLanguageBlock) {
            return ((TemplateLanguageBlock)child1).getSpacing((TemplateLanguageBlock)child2);
        }
        if (child1 instanceof TemplateLanguageBlock || child2 instanceof TemplateLanguageBlock) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    public boolean isTextContainingTemplateElements() {
        if (this.isTextElement()) {
            for (ASTNode child2 = this.myNode.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                if (!this.myBuilder.isOuterLanguageElement(child2.getPsi())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<Block> splitComment() {
        if (this.myNode.getElementType() != XmlElementType.XML_COMMENT) {
            return EMPTY;
        }
        ArrayList<AbstractXmlBlock> result2 = new ArrayList<AbstractXmlBlock>(3);
        boolean hasOuterLangElements = false;
        for (ASTNode child2 = this.myNode.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (child2 instanceof OuterLanguageElement) {
                hasOuterLangElements = true;
            }
            if (this.myBuilder.isOuterLanguageElement(child2.getPsi())) {
                result2.add(this.createTemplateFragmentWrapper(child2));
                continue;
            }
            result2.add(new XmlBlock(child2, null, null, this.myXmlFormattingPolicy, this.getChildIndent(), null, this.isPreserveSpace()));
        }
        return hasOuterLangElements ? result2 : EMPTY;
    }

    private AnotherLanguageBlockWrapper createTemplateFragmentWrapper(@NotNull ASTNode child2) {
        return new AnotherLanguageBlockWrapper(child2, this.myXmlFormattingPolicy, (Block)new ReadOnlyBlock(child2), null, child2.getStartOffset(), child2.getTextRange());
    }
}

