/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckValidXmlInScriptBodyInspectionBase;
import org.jetbrains.annotations.NotNull;

public class CheckValidXmlInScriptBodyInspection
extends CheckValidXmlInScriptBodyInspectionBase {
    protected InsertQuotedCharacterQuickFix createFix(PsiElement psiElement, int offsetInElement) {
        return new InsertQuotedCharacterQuickFix(psiElement, offsetInElement);
    }

    private static class InsertQuotedCharacterQuickFix
    extends LocalQuickFixOnPsiElement {
        private final int startInElement;

        InsertQuotedCharacterQuickFix(PsiElement psiElement, int startInElement) {
            super(psiElement);
            this.startInElement = startInElement;
        }

        @NotNull
        public String getText() {
            String character = this.getXmlCharacter();
            return XmlBundle.message((String)"unescaped.xml.character.fix.message", (Object[])new Object[]{character.equals("&") ? XmlBundle.message((String)"unescaped.xml.character.fix.message.parameter", (Object[])new Object[0]) : character});
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiFile psiFile = startElement.getContainingFile();
            TextRange range2 = startElement.getTextRange();
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, psiFile.getVirtualFile(), range2.getStartOffset() + this.startInElement);
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
            if (editor == null) {
                return;
            }
            String xmlCharacter = this.getXmlCharacter();
            String replacement = xmlCharacter.equals("&") ? "&amp;" : "&lt;";
            replacement = startElement.getText().replace(xmlCharacter, replacement);
            InjectedLanguageUtil.getTopLevelEditor(editor).getDocument().replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)replacement);
        }

        private String getXmlCharacter() {
            return this.getStartElement().getText().substring(this.startInElement, this.startInElement + 1);
        }
    }
}

