/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckTagEmptyBodyInspection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CollapseTagIntention
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        return XmlBundle.message((String)"xml.inspections.replace.tag.empty.body.with.empty.end", (Object[])new Object[0]);
    }

    @Nls
    @NotNull
    public String getText() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        CollapseTagIntention.applyFix(project, descriptor.getPsiElement());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        XmlTag tag = CollapseTagIntention.getTag(editor, file2);
        return tag != null && !tag.isEmpty() && tag.getValue().getChildren().length == tag.getValue().getTextElements().length && tag.getValue().getTrimmedText().isEmpty() && CheckTagEmptyBodyInspection.isCollapsibleTag(tag);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        XmlTag tag = CollapseTagIntention.getTag(editor, file2);
        if (tag != null) {
            CollapseTagIntention.applyFix(project, (PsiElement)tag);
        }
    }

    private static XmlTag getTag(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        FileViewProvider provider = file2.getViewProvider();
        for (Language language : provider.getLanguages()) {
            PsiElement element = provider.findElementAt(offset, language);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag == null || XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode()) == null) continue;
            return tag;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected static void applyFix(@NotNull Project project, @NotNull PsiElement tag) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ASTNode child2 = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (child2 == null) {
            return;
        }
        int offset = child2.getTextRange().getStartOffset();
        VirtualFile file2 = tag.getContainingFile().getVirtualFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        assert (document != null);
        document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).reformat(tag);
    }
}

