/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.JdomKt;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import gnu.trove.THashSet;
import java.io.InputStream;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HTMLControls {
    private static final Logger LOG = Logger.getInstance(HTMLControls.class);
    private static Control[] ourControls;

    public static Control[] getControls() {
        if (ourControls == null) {
            ourControls = HTMLControls.loadControls();
        }
        return ourControls;
    }

    private static Control[] loadControls() {
        Element element;
        try {
            byte[] bytes;
            try (InputStream stream = HTMLControls.class.getResourceAsStream("HtmlControls.xml");){
                bytes = FileUtilRt.loadBytes((InputStream)stream);
            }
            var3_1 = null;
            try (UnsyncByteArrayInputStream bytesStream = new UnsyncByteArrayInputStream(bytes);){
                element = JdomKt.loadElement((InputStream)CharsetToolkit.inputStreamSkippingBOM((InputStream)bytesStream));
            }
            catch (Throwable throwable) {
                var3_1 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return new Control[0];
        }
        if (!element.getName().equals("htmlControls")) {
            LOG.error("HTMLControls storage is broken");
            return new Control[0];
        }
        return (Control[])XmlSerializer.deserialize((Element)element, Control[].class);
    }

    private static class AutoCloseConverter
    extends Converter<Set<String>> {
        private AutoCloseConverter() {
        }

        @Nullable
        public Set<String> fromString(@NotNull String value) {
            THashSet result2 = new THashSet();
            for (String closingTag : StringUtil.split((String)value, (String)",")) {
                result2.add((Object)closingTag.trim().toLowerCase(Locale.US));
            }
            return result2;
        }

        @NotNull
        public String toString(@NotNull Set<String> o) {
            return StringUtil.join(o, (String)", ");
        }
    }

    private static class TagStateConverter
    extends Converter<TagState> {
        private TagStateConverter() {
        }

        @Nullable
        public TagState fromString(@NotNull String value) {
            return TagState.valueOf(value.toUpperCase(Locale.US));
        }

        @NotNull
        public String toString(@NotNull TagState state) {
            return state.name().toLowerCase(Locale.US);
        }
    }

    @Tag(value="control")
    public static class Control {
        @Attribute(value="name")
        public String name;
        @Attribute(value="startTag", converter=TagStateConverter.class)
        public TagState startTag;
        @Attribute(value="endTag", converter=TagStateConverter.class)
        public TagState endTag;
        @Attribute(value="emptyAllowed")
        public boolean emptyAllowed;
        @Attribute(value="autoClosedBy", converter=AutoCloseConverter.class)
        public Set<String> autoClosedBy = Collections.emptySet();
    }

    public static enum TagState {
        REQUIRED,
        OPTIONAL,
        FORBIDDEN;

    }
}

