/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.xml.util.IncludedXmlTag;
import com.intellij.xml.util.XmlIncludeHandler;
import com.intellij.xml.util.XmlUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InclusionProvider
implements CachedValueProvider<PsiElement[]> {
    private final XmlTag myXincludeTag;

    InclusionProvider(XmlTag xincludeTag) {
        this.myXincludeTag = xincludeTag;
    }

    @NotNull
    public static PsiElement[] getIncludedTags(XmlTag xincludeTag) {
        if (XmlUtil.isStubBuilding()) {
            return PsiElement.EMPTY_ARRAY;
        }
        return (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)xincludeTag, (CachedValueProvider)new InclusionProvider(xincludeTag));
    }

    public CachedValueProvider.Result<PsiElement[]> compute() {
        PsiElement[] result2 = (PsiElement[])RecursionManager.doPreventingRecursion((Object)this.myXincludeTag, (boolean)true, (Computable)((NullableComputable)() -> InclusionProvider.computeInclusion(this.myXincludeTag)));
        return CachedValueProvider.Result.create((Object)(result2 == null ? PsiElement.EMPTY_ARRAY : result2), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
    }

    private static XmlTag[] extractXpointer(@NotNull XmlTag rootTag, @Nullable String xpointer) {
        String pointer;
        Matcher matcher;
        if (xpointer != null && (matcher = JDOMXIncluder.XPOINTER_PATTERN.matcher(xpointer)).matches() && (matcher = JDOMXIncluder.CHILDREN_PATTERN.matcher(pointer = matcher.group(1))).matches() && matcher.group(1).equals(rootTag.getName())) {
            return rootTag.getSubTags();
        }
        return new XmlTag[]{rootTag};
    }

    @Nullable
    private static PsiElement[] computeInclusion(XmlTag xincludeTag) {
        XmlTag rootTag;
        XmlFile included = XmlIncludeHandler.resolveXIncludeFile(xincludeTag);
        XmlDocument document = included != null ? included.getDocument() : null;
        XmlTag xmlTag = rootTag = document != null ? document.getRootTag() : null;
        if (rootTag != null) {
            String xpointer = xincludeTag.getAttributeValue("xpointer", "http://www.w3.org/2001/XInclude");
            XmlTag[] includeTag = InclusionProvider.extractXpointer(rootTag, xpointer);
            PsiElement[] result2 = new PsiElement[includeTag.length];
            for (int i = 0; i < includeTag.length; ++i) {
                result2[i] = new IncludedXmlTag(includeTag[i], (PsiElement)xincludeTag.getParentTag());
            }
            return result2;
        }
        return null;
    }
}

