/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorPickerListenerFactory;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Function;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserColorLookup
extends LookupElementDecorator<LookupElement> {
    private static final String COLOR_STRING = XmlBundle.message((String)"choose.color.in.color.lookup", (Object[])new Object[0]);
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = color -> '#' + ColorUtil.toHex((Color)color);

    public UserColorLookup() {
        this(COLOR_TO_STRING_CONVERTER);
    }

    public UserColorLookup(Function<? super Color, String> colorToStringConverter) {
        this(colorToStringConverter, 2);
    }

    public UserColorLookup(final Function<? super Color, String> colorToStringConverter, int priority) {
        super(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)COLOR_STRING).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                UserColorLookup.handleUserSelection(context, (Function<? super Color, String>)colorToStringConverter);
            }
        }), (double)priority));
    }

    private static void handleUserSelection(InsertionContext context, @NotNull Function<? super Color, String> colorToStringConverter) {
        Project project = context.getProject();
        Editor editor = context.getEditor();
        int startOffset = context.getStartOffset();
        context.getDocument().deleteString(startOffset, context.getTailOffset());
        PsiElement element = context.getFile().findElementAt(editor.getCaretModel().getOffset());
        Color myColorAtCaret = element instanceof XmlToken ? UserColorLookup.getColorFromElement(element) : null;
        context.setLaterRunnable(() -> {
            if (editor.isDisposed() || project.isDisposed()) {
                return;
            }
            List<ColorPickerListener> listeners = ColorPickerListenerFactory.createListenersFor(element);
            Color color = ColorChooser.chooseColor((Project)project, (Component)WindowManager.getInstance().suggestParentWindow(project), (String)XmlBundle.message((String)"choose.color.dialog.title", (Object[])new Object[0]), (Color)myColorAtCaret, (boolean)true, listeners, (boolean)true);
            if (color != null) {
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    editor.getCaretModel().moveToOffset(startOffset);
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)((String)colorToStringConverter.fun((Object)color)));
                });
            }
        });
    }

    @Nullable
    public static Color getColorFromElement(PsiElement element) {
        if (!(element instanceof XmlToken)) {
            return null;
        }
        return ColorMap.getColor(element.getText());
    }
}

