/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.openapi.util.Key;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiDelegateReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import com.intellij.xml.impl.schema.XmlSchemaTagsProcessor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlEnumeratedValueReferenceProvider<T extends PsiElement>
extends PsiReferenceProvider {
    public static final Key<Boolean> SUPPRESS = Key.create((String)"suppress attribute value references");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (XmlSchemaTagsProcessor.PROCESSING_FLAG.get() != null || context.get(SUPPRESS) != null) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement host = this.getHost(element);
        if (host instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)host)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (XmlHighlightVisitor.skipValidation(element)) {
            return PsiReference.EMPTY_ARRAY;
        }
        String unquotedValue = ElementManipulators.getValueText((PsiElement)element);
        if (!XmlUtil.isSimpleValue(unquotedValue, element)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Object descriptor = this.getDescriptor(element);
        if (descriptor instanceof XmlEnumerationDescriptor) {
            XmlEnumerationDescriptor enumerationDescriptor = (XmlEnumerationDescriptor)descriptor;
            if (enumerationDescriptor.isFixed() || enumerationDescriptor.isEnumerated((XmlElement)element)) {
                return enumerationDescriptor.getValueReferences((XmlElement)element, unquotedValue);
            }
            if (unquotedValue.equals(enumerationDescriptor.getDefaultValue())) {
                return (PsiReference[])ContainerUtil.map2Array((Object[])enumerationDescriptor.getValueReferences((XmlElement)element, unquotedValue), PsiReference.class, reference -> PsiDelegateReference.createSoft(reference, true));
            }
        }
        return PsiReference.EMPTY_ARRAY;
    }

    protected PsiElement getHost(T element) {
        return element;
    }

    protected Object getDescriptor(T element) {
        PsiElement parent = element.getParent();
        return parent instanceof XmlAttribute ? ((XmlAttribute)parent).getDescriptor() : null;
    }

    public static XmlEnumeratedValueReferenceProvider forTags() {
        return new XmlEnumeratedValueReferenceProvider<XmlTag>(){

            @Override
            protected Object getDescriptor(XmlTag element) {
                return element.getDescriptor();
            }

            @Override
            protected PsiElement getHost(XmlTag element) {
                Object[] textElements = element.getValue().getTextElements();
                return (PsiElement)ArrayUtil.getFirstElement((Object[])textElements);
            }
        };
    }
}

