/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNSDescriptorSequence
implements XmlNSDescriptor {
    final List<XmlNSDescriptor> sequence = new ArrayList<XmlNSDescriptor>();

    public XmlNSDescriptorSequence() {
    }

    public XmlNSDescriptorSequence(XmlNSDescriptor[] descriptors) {
        for (XmlNSDescriptor descriptor : descriptors) {
            this.add(descriptor);
        }
    }

    public void add(XmlNSDescriptor descriptor) {
        this.sequence.add(descriptor);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        for (XmlNSDescriptor descriptor : this.sequence) {
            XmlElementDescriptor elementDescriptor = descriptor.getElementDescriptor(tag);
            if (elementDescriptor == null) continue;
            return elementDescriptor;
        }
        return null;
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        ArrayList descriptors = new ArrayList();
        for (XmlNSDescriptor descriptor : this.sequence) {
            ContainerUtil.addAll(descriptors, (Object[])descriptor.getRootElementsDescriptors(document));
        }
        return descriptors.toArray(XmlElementDescriptor.EMPTY_ARRAY);
    }

    public XmlFile getDescriptorFile() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            XmlFile file2 = descriptor.getDescriptorFile();
            if (file2 == null) continue;
            return file2;
        }
        return null;
    }

    public List<XmlNSDescriptor> getSequence() {
        return this.sequence;
    }

    public PsiElement getDeclaration() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            PsiElement declaration = descriptor.getDeclaration();
            if (declaration == null) continue;
            return declaration;
        }
        return null;
    }

    public String getName(PsiElement context) {
        for (XmlNSDescriptor descriptor : this.sequence) {
            String name = descriptor.getName(context);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public String getName() {
        for (XmlNSDescriptor descriptor : this.sequence) {
            String name = descriptor.getName();
            if (name == null) continue;
            return name;
        }
        return null;
    }

    public void init(PsiElement element) {
        for (XmlNSDescriptor descriptor : this.sequence) {
            descriptor.init(element);
        }
    }

    @NotNull
    public Object[] getDependencies() {
        ArrayList ret = new ArrayList();
        for (XmlNSDescriptor descriptor : this.sequence) {
            ContainerUtil.addAll(ret, (Object[])descriptor.getDependencies());
        }
        return ret.toArray();
    }
}

