/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.documentation.CompositeAttributeTagDescriptor;
import com.intellij.xml.util.documentation.EntityDescriptor;
import com.intellij.xml.util.documentation.HtmlAttributeDescriptor;
import com.intellij.xml.util.documentation.HtmlCompatibilityData;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import com.intellij.xml.util.documentation.HtmlTagDescriptor;
import com.intellij.xml.util.documentation.MdnDocumentationUtil;
import com.intellij.xml.util.documentation.XmlDocumentationProvider;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private static final ExtensionPointName<DocumentationProvider> SCRIPT_PROVIDER_EP_NAME = ExtensionPointName.create((String)"com.intellij.html.scriptDocumentationProvider");
    private DocumentationProvider myStyleProvider = null;
    private final boolean myUseStyleProvider;
    @NonNls
    public static final String ELEMENT_ELEMENT_NAME = "element";
    @NonNls
    public static final String NBSP = ":&nbsp;";
    @NonNls
    public static final String BR = "<br>";
    private static final SynchronizedClearableLazy<DocumentationProvider> ourScriptProvider = new SynchronizedClearableLazy(() -> (DocumentationProvider)ContainerUtil.getFirstItem((List)SCRIPT_PROVIDER_EP_NAME.getExtensionList()));

    public HtmlDocumentationProvider() {
        this(true);
    }

    public HtmlDocumentationProvider(boolean useStyleProvider) {
        this.myUseStyleProvider = useStyleProvider;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof SchemaPrefix) {
            return ((SchemaPrefix)element).getQuickNavigateInfo();
        }
        return null;
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String result2 = HtmlDocumentationProvider.getUrlForHtml(element, originalElement, (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false));
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            return styleProvider.getUrlFor(element, originalElement);
        }
        return result2 != null ? Collections.singletonList(result2) : null;
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        XmlTag tag = element instanceof XmlElement ? (XmlTag)ReadAction.compute(() -> (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false)) : null;
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)element.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        PsiElement originalElement = pointer != null ? (PsiElement)ReadAction.compute(() -> ((SmartPsiElementPointer)pointer).getElement()) : element;
        DocEntity entity = (DocEntity)ReadAction.compute(() -> HtmlDocumentationProvider.findDocumentationEntity(element, tag));
        for (String url : docUrls) {
            if (!url.contains("#attr-")) continue;
            return null;
        }
        String mdnDoc = MdnDocumentationUtil.fetchExternalDocumentation(docUrls, () -> null);
        if (mdnDoc != null) {
            String name = entity != null ? entity.name : (String)ReadAction.compute(() -> SymbolPresentationUtil.getSymbolPresentableText(element));
            Map mdnCompatData = (Map)ReadAction.compute(() -> HtmlDocumentationProvider.getCompatData(entity, originalElement));
            return MdnDocumentationUtil.buildDoc(name, mdnDoc, mdnCompatData);
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return false;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    public static String getUrlForHtml(PsiElement element, PsiElement originalElement, XmlTag context) {
        DocEntity entity = HtmlDocumentationProvider.findDocumentationEntity(element, context);
        String mdnUrl = MdnDocumentationUtil.getMdnUrl(HtmlDocumentationProvider.getCompatData(entity, originalElement));
        if (mdnUrl != null) {
            return mdnUrl;
        }
        EntityDescriptor descriptor = HtmlDocumentationProvider.findDocumentationDescriptor(entity, context);
        if (descriptor instanceof HtmlAttributeDescriptor && context != null) {
            return "https://developer.mozilla.org/docs/Web/HTML/Element/" + context.getName() + "#attr-" + descriptor.getName();
        }
        return descriptor != null ? descriptor.getHelpRef() : null;
    }

    @NotNull
    private static DocEntity findDocumentationEntity(PsiElement element, XmlTag context) {
        int dotIndex;
        XmlAttribute xmlAttribute;
        boolean isTag = true;
        PsiElement nameElement = null;
        String key = null;
        if (element instanceof FakePsiElement) {
            nameElement = element.getNavigationElement();
            isTag = nameElement != null && nameElement.getParent().getText().startsWith(ELEMENT_ELEMENT_NAME);
        } else if (element instanceof XmlElementDecl) {
            nameElement = ((XmlElementDecl)element).getNameElement();
        } else if (element instanceof XmlAttributeDecl) {
            nameElement = ((XmlAttributeDecl)element).getNameElement();
            isTag = false;
        } else if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            key = metaData != null ? metaData.getName() : null;
            isTag = xmlTag.getLocalName().equals(ELEMENT_ELEMENT_NAME);
        } else if (element.getParent() instanceof XmlAttributeValue) {
            isTag = false;
            key = ((XmlAttribute)element.getParent().getParent()).getName();
        } else if (element instanceof XmlAttributeValue) {
            isTag = false;
            xmlAttribute = (XmlAttribute)element.getParent();
            key = xmlAttribute.getName();
        } else if (element instanceof XmlAttribute) {
            xmlAttribute = (XmlAttribute)element;
            isTag = false;
            key = xmlAttribute.getName();
        } else if (element instanceof XmlElement) {
            nameElement = element;
            isTag = !(element.getParent() instanceof XmlAttribute);
        } else {
            nameElement = element;
            if (context != null) {
                String text = element.getText();
                boolean bl = isTag = text != null && text.startsWith(context.getName());
            }
        }
        if (nameElement != null) {
            key = nameElement.getText();
        }
        if ((dotIndex = (key = StringUtil.notNullize(key).toLowerCase(Locale.US)).indexOf(46)) > 0) {
            key = key.substring(0, dotIndex);
        }
        return new DocEntity(key, isTag);
    }

    private static EntityDescriptor findDocumentationDescriptor(DocEntity entity, XmlTag context) {
        if (entity.isTag) {
            return HtmlDescriptorsTable.getTagDescriptor(entity.name);
        }
        return HtmlDocumentationProvider.getDescriptor(entity.name, context);
    }

    private static HtmlAttributeDescriptor getDescriptor(String name, XmlTag context) {
        HtmlAttributeDescriptor attributeDescriptor = HtmlDescriptorsTable.getAttributeDescriptor(name);
        if (attributeDescriptor instanceof CompositeAttributeTagDescriptor) {
            return ((CompositeAttributeTagDescriptor)attributeDescriptor).findHtmlAttributeInContext(context);
        }
        return attributeDescriptor;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        DocumentationProvider scriptProvider;
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class, (boolean)false);
        String result2 = this.generateDocForHtml(element, tag, originalElement);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.generateDoc(element, originalElement);
        }
        if (result2 == null && (scriptProvider = ourScriptProvider.getValue()) != null) {
            result2 = scriptProvider.generateDoc(element, originalElement);
        }
        if (result2 == null && element instanceof XmlAttributeValue) {
            result2 = this.generateDocForHtml(element.getParent(), tag, originalElement);
        }
        return result2;
    }

    protected String generateDocForHtml(PsiElement element, XmlTag context, PsiElement originalElement) {
        DocEntity entity = HtmlDocumentationProvider.findDocumentationEntity(element, context);
        EntityDescriptor descriptor = HtmlDocumentationProvider.findDocumentationDescriptor(entity, context);
        if (descriptor != null) {
            String description = descriptor.getDescription();
            if (!description.endsWith(".")) {
                description = description + ".";
            }
            Map mdnData = (Map)ReadAction.compute(() -> HtmlDocumentationProvider.getCompatData(entity, originalElement));
            return MdnDocumentationUtil.buildDoc(descriptor.getName(), description, mdnData);
        }
        if (element instanceof XmlEntityDecl) {
            XmlEntityDecl entityDecl = (XmlEntityDecl)element;
            return new XmlDocumentationProvider().findDocRightAfterElement(element, entityDecl.getName());
        }
        return null;
    }

    @Nullable
    private static Map getCompatData(DocEntity entity, @Nullable PsiElement element) {
        if (element != null && LookupManager.getInstance(element.getProject()).getActiveLookup() == null) {
            XmlAttribute attribute = (XmlAttribute)ReadAction.compute(() -> (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)true));
            if (attribute != null) {
                return HtmlCompatibilityData.getAttributeData(attribute.getParent(), attribute.getName());
            }
            if (element.getParent() instanceof XmlTag) {
                return HtmlCompatibilityData.getTagData((XmlTag)element.getParent());
            }
        }
        if (entity.isTag) {
            return HtmlCompatibilityData.getTagData("", entity.name);
        }
        XmlTag tag = (XmlTag)ReadAction.compute(() -> (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)true));
        if (tag != null) {
            return HtmlCompatibilityData.getAttributeData(tag, entity.name);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        DocumentationProvider scriptProvider;
        PsiElement result2 = this.createNavigationElementHTML(psiManager, object.toString(), element);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result2 == null && (scriptProvider = ourScriptProvider.getValue()) != null) {
            result2 = scriptProvider.getDocumentationElementForLookupItem(psiManager, object, element);
        }
        if (result2 == null && object instanceof String && element != null) {
            result2 = XmlDocumentationProvider.findDeclWithName((String)object, element);
        }
        return result2;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link2, PsiElement context) {
        PsiElement result2 = this.createNavigationElementHTML(psiManager, link2, context);
        DocumentationProvider styleProvider = this.getStyleProvider();
        if (result2 == null && styleProvider != null) {
            result2 = styleProvider.getDocumentationElementForLink(psiManager, link2, context);
        }
        if (result2 == null && ourScriptProvider.getValue() != null && !DumbService.isDumb((Project)psiManager.getProject())) {
            result2 = ourScriptProvider.getValue().getDocumentationElementForLink(psiManager, link2, context);
        }
        return result2;
    }

    public PsiElement createNavigationElementHTML(PsiManager psiManager, String text, PsiElement context) {
        String key = text.toLowerCase(Locale.US);
        HtmlTagDescriptor descriptor = HtmlDescriptorsTable.getTagDescriptor(key);
        if (descriptor != null && !this.isAttributeContext(context)) {
            try {
                XmlTag tagFromText = XmlElementFactory.getInstance((Project)psiManager.getProject()).createTagFromText((CharSequence)("<" + key + " xmlns=\"" + "http://www.w3.org/1999/xhtml" + "\"/>"));
                XmlElementDescriptor tagDescriptor = tagFromText.getDescriptor();
                return tagDescriptor != null ? tagDescriptor.getDeclaration() : null;
            }
            catch (IncorrectOperationException tagFromText) {}
        } else {
            XmlTag tagContext = this.findTagContext(context);
            HtmlAttributeDescriptor myAttributeDescriptor = HtmlDocumentationProvider.getDescriptor(key, tagContext);
            if (myAttributeDescriptor != null && tagContext != null) {
                XmlElementDescriptor tagDescriptor = tagContext.getDescriptor();
                XmlAttributeDescriptor attributeDescriptor = tagDescriptor != null ? tagDescriptor.getAttributeDescriptor(text, tagContext) : null;
                return attributeDescriptor != null ? attributeDescriptor.getDeclaration() : null;
            }
        }
        return null;
    }

    protected boolean isAttributeContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof XmlAttribute) {
            return true;
        }
        return context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlAttribute;
    }

    protected XmlTag findTagContext(PsiElement context) {
        PsiElement prevSibling;
        if (context instanceof PsiWhiteSpace && (prevSibling = context.getPrevSibling()) instanceof XmlTag) {
            return (XmlTag)prevSibling;
        }
        return (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
    }

    public static void registerScriptDocumentationProvider(@NotNull DocumentationProvider provider, @NotNull Disposable parentDisposable) {
        ourScriptProvider.setValue(provider);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourScriptProvider.setValue(null);
            }
        });
    }

    @Nullable
    private DocumentationProvider getStyleProvider() {
        Language cssLanguage;
        if (!this.myUseStyleProvider) {
            return null;
        }
        if (this.myStyleProvider == null && (cssLanguage = Language.findLanguageByID((String)"CSS")) != null) {
            this.myStyleProvider = LanguageDocumentation.INSTANCE.forLanguage(cssLanguage);
        }
        return this.myStyleProvider;
    }

    private static class DocEntity {
        String name;
        boolean isTag;

        private DocEntity(String name, boolean isTag) {
            this.name = name;
            this.isTag = isTag;
        }
    }
}

